/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

class EntrySetSortedIterator
implements Iterator<Integer> {
    private final Iterator<Map.Entry<Object, Set<Integer>>> entryIt;
    private final boolean forward;
    private Iterator<Integer> nextIds;
    private Integer next;

    EntrySetSortedIterator(Iterator<Map.Entry<Object, Set<Integer>>> entryIt, boolean forward) {
        this.entryIt = entryIt;
        this.forward = forward;
    }

    @Nullable
    private Iterator<Integer> getNextIds() {
        if (this.nextIds != null && this.nextIds.hasNext()) {
            return this.nextIds;
        }
        while (this.entryIt.hasNext()) {
            Set<Integer> ids = this.entryIt.next().getValue();
            if (ids.size() == 0) continue;
            ArrayList<Integer> list = new ArrayList<Integer>(ids);
            list.sort(this.forward ? Comparator.naturalOrder() : Comparator.reverseOrder());
            this.nextIds = list.iterator();
            return this.nextIds;
        }
        this.nextIds = null;
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        Iterator<Integer> ids = this.getNextIds();
        if (ids == null) {
            return false;
        }
        this.next = ids.next();
        return true;
    }

    @Override
    public Integer next() {
        if (this.hasNext()) {
            Integer val = this.next;
            this.next = null;
            return val;
        }
        throw new NoSuchElementException();
    }
}

