/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.internal;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSlaveForEnduser;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.search.ReaStepIndexData;
import com.inet.helpdesk.ticketmanager.search.TicketDataForIndexingVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketChangeCollector {
    private final TicketReadDAO readDAO;
    private final boolean withAllStepTexts;
    private final List<Integer> changedTicketIDs;
    private final Map<Integer, TicketDataForIndexingVO> ticketsBefore = new HashMap<Integer, TicketDataForIndexingVO>();
    private final Map<Integer, Set<Integer>> stepsAffectedByChangePerTicket = new HashMap<Integer, Set<Integer>>();
    private final Map<Integer, Boolean> ticketHasReaStepUpdate = new HashMap<Integer, Boolean>();

    private TicketChangeCollector(TicketReadDAO readDAO, TicketVO ticket, boolean withAllStepTexts) {
        if (readDAO == null) {
            throw new IllegalArgumentException("readDAO must not be null");
        }
        this.readDAO = readDAO;
        this.withAllStepTexts = withAllStepTexts;
        this.changedTicketIDs = new ArrayList<Integer>();
        if (ticket != null) {
            this.collectChangedTicket(ticket.getID());
        }
    }

    public static TicketChangeCollector start(TicketReadDAO readDAO, TicketVO ticket, boolean withAllStepTexts) {
        if (ticket == null) {
            throw new IllegalArgumentException("ticket must not be null");
        }
        return new TicketChangeCollector(readDAO, ticket, withAllStepTexts);
    }

    public static TicketChangeCollector start(TicketReadDAO readDAO, boolean withAllStepTexts) {
        return new TicketChangeCollector(readDAO, null, withAllStepTexts);
    }

    public void collectChangedTicket(int ticketID) {
        List<Integer> newIds;
        if (this.changedTicketIDs.contains(ticketID)) {
            return;
        }
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        if (ticket.isUnbundled()) {
            newIds = Collections.singletonList(ticket.getID());
        } else {
            newIds = this.readDAO.getTicketIDsForBundleID(ticket.getBundleID());
            if (newIds.isEmpty()) {
                throw new IllegalStateException("For ticket " + ticketID + " cannot find any info in database. ticket=" + ticket.toString());
            }
        }
        for (Integer newID : newIds) {
            if (this.changedTicketIDs.contains(newID)) continue;
            this.changedTicketIDs.add(newID);
            this.collectData(newID, this.ticketsBefore, false);
        }
    }

    public void collectNewCreatedTicket(int ticketID) {
        if (this.changedTicketIDs.contains(ticketID)) {
            return;
        }
        this.changedTicketIDs.add(ticketID);
    }

    public void markAddedReaStep(int ticketID, int stepID) {
        this.markAffectedReaStep(ticketID, stepID);
    }

    public void markUpdatedReaStep(int ticketID, int stepID) {
        this.markAffectedReaStep(ticketID, stepID);
        if (!this.withAllStepTexts && !this.ticketHasReaStepUpdate.getOrDefault(ticketID, false).booleanValue()) {
            this.ticketHasReaStepUpdate.put(ticketID, Boolean.TRUE);
            this.collectData(ticketID, this.ticketsBefore, false);
        }
    }

    private void markAffectedReaStep(int ticketID, int stepID) {
        Set<Integer> affectedStepIDs;
        if (!this.changedTicketIDs.contains(ticketID)) {
            this.logThatCollectorIsCalledWithIdOfUnmarkedTicket(ticketID);
            return;
        }
        if (!this.stepsAffectedByChangePerTicket.containsKey(ticketID)) {
            this.stepsAffectedByChangePerTicket.put(ticketID, new HashSet());
        }
        if ((affectedStepIDs = this.stepsAffectedByChangePerTicket.get(ticketID)) != null) {
            this.stepsAffectedByChangePerTicket.get(ticketID).add(stepID);
        }
    }

    public void markThatAllReaStepsMayBeAffected(int ticketID) {
        if (!this.changedTicketIDs.contains(ticketID)) {
            this.logThatCollectorIsCalledWithIdOfUnmarkedTicket(ticketID);
            return;
        }
        this.stepsAffectedByChangePerTicket.put(ticketID, null);
    }

    private void logThatCollectorIsCalledWithIdOfUnmarkedTicket(int ticketID) {
        HDLogger.debug(new Throwable(String.format("TicketChangeCollector is called with ID of ticket that was not marked beforehand as \"changed\": TicketID = \"%d\"", ticketID)));
    }

    public TicketChangeCollectorResult collectChanges() {
        HashMap<Integer, TicketDataForIndexingVO> ticketsAfter = new HashMap<Integer, TicketDataForIndexingVO>();
        this.collectData(this.changedTicketIDs, ticketsAfter);
        ArrayList<TicketDataForIndexingVO.TicketDataForIndexingVOPair> dataForIndexing = new ArrayList<TicketDataForIndexingVO.TicketDataForIndexingVOPair>();
        ArrayList<ChangedTicketVO> dataForEvent = new ArrayList<ChangedTicketVO>();
        boolean includeAffectedStepIDs = true;
        for (Integer ticketID : this.changedTicketIDs) {
            TicketDataForIndexingVO dataBefore = this.ticketsBefore.get(ticketID);
            TicketDataForIndexingVO dataAfter = (TicketDataForIndexingVO)ticketsAfter.get(ticketID);
            if (dataBefore == null && dataAfter == null) continue;
            TicketDataForIndexingVO.TicketDataForIndexingVOPair pair = new TicketDataForIndexingVO.TicketDataForIndexingVOPair(dataBefore, dataAfter);
            dataForIndexing.add(pair);
            Set<Integer> stepIDs = null;
            if (includeAffectedStepIDs) {
                stepIDs = this.stepsAffectedByChangePerTicket.containsKey(ticketID) ? this.stepsAffectedByChangePerTicket.get(ticketID) : Collections.emptySet();
            }
            TicketVO ticketBefore = dataBefore == null ? null : dataBefore.getTicket();
            TicketVO ticketAfter = dataAfter == null ? null : dataAfter.getTicket();
            ChangedTicketVO changedTicket = new ChangedTicketVO(ticketBefore, ticketAfter, stepIDs);
            dataForEvent.add(changedTicket);
        }
        return new TicketChangeCollectorResult(dataForIndexing, dataForEvent);
    }

    private void collectData(List<Integer> ticketIDs, Map<Integer, TicketDataForIndexingVO> ticketMap) {
        for (int ticketID : ticketIDs) {
            this.collectData(ticketID, ticketMap, true);
        }
    }

    private void collectData(int ticketID, Map<Integer, TicketDataForIndexingVO> ticketMap, boolean includeAffectedReaStepTexts) {
        TicketVO ticket = TicketChangeCollector.loadTicketData(this.readDAO, ticketID);
        TicketDataForIndexingVO indexData = null;
        if (ticket != null) {
            Set<Integer> stepIDs;
            if (this.withAllStepTexts || this.ticketHasReaStepUpdate.getOrDefault(ticketID, false).booleanValue()) {
                Map<@Nonnull Integer, @Nonnull ReaStepTextVO> reaStepTexts = this.readDAO.getReaStepTextsForTicket(ticketID);
                indexData = this.getDataForIndexing(ticket, reaStepTexts);
            } else if (includeAffectedReaStepTexts && (stepIDs = this.stepsAffectedByChangePerTicket.get(ticketID)) != null) {
                HashMap<@Nonnull Integer, @Nonnull ReaStepTextVO> reaStepTexts = new HashMap<Integer, ReaStepTextVO>();
                for (Integer reaStepID : stepIDs) {
                    ReaStepTextVO reaStepText = this.readDAO.getReaStepText(reaStepID);
                    if (reaStepText == null) continue;
                    reaStepTexts.put(reaStepID, reaStepText);
                }
                indexData = this.getDataForIndexing(ticket, reaStepTexts);
            }
            if (indexData == null) {
                indexData = this.getDataForIndexing(ticket, null);
            }
        }
        ticketMap.put(ticketID, indexData);
    }

    @Nonnull
    private TicketDataForIndexingVO getDataForIndexing(@Nonnull TicketVO ticket, @Nullable Map<@Nonnull Integer, @Nonnull ReaStepTextVO> reaStepTexts) {
        Map<Integer, ReaStepIndexData> reaStepData;
        if (reaStepTexts == null || reaStepTexts.isEmpty()) {
            reaStepData = Map.of();
        } else {
            reaStepData = new HashMap();
            for (Map.Entry<Integer, ReaStepTextVO> entry : reaStepTexts.entrySet()) {
                Integer reaStepID = entry.getKey();
                ReaStepVO reaStep = this.readDAO.getReaStep(reaStepID);
                reaStepData.put(reaStepID, new ReaStepIndexData(entry.getValue(), reaStep));
            }
        }
        return new TicketDataForIndexingVO(ticket, reaStepData);
    }

    public static TicketVO loadTicketData(TicketReadDAO readDAO, int ticketID) {
        TicketVOSingle ticket = readDAO.getTicket(ticketID);
        if (ticket != null && ticket.isSlaveInBundle()) {
            TicketVOSingle master = readDAO.getTicket(ticket.getBundleID());
            if (master == null) {
                return null;
            }
            return TicketVOSlaveForEnduser.create(ticket, master);
        }
        return ticket;
    }

    public static class TicketChangeCollectorResult {
        private List<TicketDataForIndexingVO.TicketDataForIndexingVOPair> dataForIndexing;
        private List<ChangedTicketVO> dataForEvent;

        public TicketChangeCollectorResult(@Nonnull List<TicketDataForIndexingVO.TicketDataForIndexingVOPair> dataForIndexing, @Nonnull List<ChangedTicketVO> dataForEvent) {
            this.dataForIndexing = dataForIndexing;
            this.dataForEvent = dataForEvent;
        }

        public List<TicketDataForIndexingVO.TicketDataForIndexingVOPair> getDataForIndexing() {
            return this.dataForIndexing;
        }

        public List<ChangedTicketVO> getDataForEvent() {
            return this.dataForEvent;
        }
    }
}

