/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.model;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.model.Field;
import java.io.Serializable;
import java.util.HashMap;

@JsonData
public class FieldInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> displayNames = new HashMap();
    private HashMap<String, Integer> fieldMaxLength = new HashMap();
    private final String language;

    private FieldInformation() {
        this.language = "de";
    }

    public FieldInformation(String language) {
        this.language = language;
    }

    public void addFieldDisplayName(String field, String displayName) {
        this.displayNames.put(field, displayName);
    }

    public String getFieldDisplayName(String field) {
        String dName = this.displayNames.get(field);
        if (dName != null) {
            return dName;
        }
        try {
            Field f = Field.valueOf(field);
            return f.getKey();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return field;
        }
    }

    public HashMap<String, String> getDisplayNames() {
        return this.displayNames;
    }

    public String getLanguage() {
        return this.language;
    }

    public int getFieldMaxLength(String field) {
        Integer fLength = this.fieldMaxLength.get(field);
        if (fLength != null) {
            return fLength;
        }
        return -1;
    }

    public void addFieldMaxLength(String field, int maxLength) {
        this.fieldMaxLength.put(field, maxLength);
    }
}

