/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.model;

import com.inet.annotations.JsonData;
import com.inet.lib.util.IOFunctions;

@JsonData
public class DataObjectDescription {
    private final boolean valid;
    private final String name;
    private final String display;
    private final int id;
    private final String payload;

    private DataObjectDescription() {
        this(0, null);
    }

    public DataObjectDescription(int id, String valueString) {
        this(id, valueString, null, null, true);
    }

    public DataObjectDescription(int id, String valueString, boolean valid) {
        this(id, valueString, null, null, valid);
    }

    public DataObjectDescription(int id, String valueString, Object payload, boolean valid) {
        this(id, valueString, null, payload, valid);
    }

    public DataObjectDescription(int id, String valueString, String displayString, Object payload, boolean valid) {
        this.valid = valid;
        this.name = valueString;
        this.display = displayString;
        this.id = id;
        this.payload = IOFunctions.toJsonNullable((Object)payload);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getValueString() {
        return this.name;
    }

    public int getKeyValue() {
        return this.id;
    }

    public String getDisplayString() {
        return this.display != null ? this.display : this.name;
    }

    public <T> T getPayload(Class<T> type) {
        return (T)IOFunctions.fromJsonNullable((String)this.payload, type);
    }

    public String toString() {
        return this.getDisplayString() != null ? this.getDisplayString() : this.getValueString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataObjectDescription)) {
            return false;
        }
        DataObjectDescription other = (DataObjectDescription)obj;
        if (this.valid != other.valid) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(other.name) : other.name != null) {
            return false;
        }
        if (this.display != null ? !this.display.equals(other.display) : other.display != null) {
            return false;
        }
        return !(this.payload != null ? !this.payload.equals(other.payload) : other.payload != null);
    }
}

