/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReaderForSystem;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.TextSearchTokenizerWithoutNormalize;
import com.inet.search.utils.UmlautsUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class TicketFieldSubViewGrouping
extends SimpleSubViewGrouping {
    private TicketField<?> field;

    public TicketFieldSubViewGrouping(@Nonnull TicketField<?> field) {
        super(field.getKey());
        this.field = field;
    }

    public TicketFieldSubViewGrouping(String fieldKey) {
        super(fieldKey);
    }

    private TicketField<?> getField() {
        if (this.field != null) {
            return this.field;
        }
        return Tickets.getFieldByKey(this.getKey());
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        return this.getField().getSearchTag().getDisplayName();
    }

    @Override
    public boolean supportsTokenizeGroupingValues() {
        return switch (this.getField().getSearchTag().getDataType()) {
            case SearchDataType.IntegerMap, SearchDataType.StringMap -> false;
            default -> true;
        };
    }

    @Override
    public List<SubView<?>> getSubViews(@Nonnull TicketViewFactory parent, @Nonnull GUID accountID, Locale locale, @Nonnull Set<Integer> ticketIDs) {
        ArrayList result = new ArrayList();
        TicketField<?> field = this.getField();
        SearchTag searchTag = field.getSearchTag();
        switch (searchTag.getDataType()) {
            case IntegerMap: 
            case StringMap: {
                HashMap mapView = new HashMap();
                for (Map.Entry entry : searchTag.getMapData().entrySet()) {
                    Object id = entry.getKey();
                    if (id == null) continue;
                    String key = id.toString().toLowerCase();
                    mapView.put(key, new SubView(parent, this, id, (String)entry.getValue(), null, null));
                }
                if (searchTag.showAlsoNonMapValues()) {
                    this.appendNotTokenizedSubViews(mapView, parent, field, searchTag, ticketIDs);
                }
                result.addAll(mapView.values());
                break;
            }
            default: {
                if (!parent.isTokenizeGroupingValues()) {
                    HashMap map = new HashMap();
                    this.appendNotTokenizedSubViews(map, parent, field, searchTag, ticketIDs);
                    result.addAll(map.values());
                    break;
                }
                TicketReaderForSystem reader = TicketManager.getReaderForSystem();
                IndexSearchEngine<Integer> engine = reader.getSearchEngine();
                TextSearchTokenizerWithoutNormalize tokenizer = new TextSearchTokenizerWithoutNormalize();
                HashMap map = new HashMap();
                Iterator it = engine.createEntryIterator(searchTag, true);
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    Object val = entry.getKey();
                    for (String viewId : tokenizer.tokens(val, 1)) {
                        HashSet ids = (HashSet)map.get(viewId);
                        if (ids == null) {
                            ids = new HashSet((Collection)entry.getValue());
                            map.put(viewId, ids);
                            continue;
                        }
                        ids.addAll((Collection)entry.getValue());
                    }
                }
                for (Map.Entry entry : new HashMap(map).entrySet()) {
                    Set ids;
                    String viewId = (String)entry.getKey();
                    String withoutUmlaut = UmlautsUtils.replaceUmlauts((String)viewId);
                    if (!withoutUmlaut.equals(viewId) && (ids = (Set)map.get(withoutUmlaut)) != null && ids.equals(entry.getValue())) {
                        map.remove(withoutUmlaut);
                    }
                    if ((withoutUmlaut = UmlautsUtils.flattenToAscii((String)viewId)).equals(viewId) || (ids = (Set)map.get(withoutUmlaut)) == null || !ids.equals(entry.getValue())) continue;
                    map.remove(withoutUmlaut);
                }
                for (String viewId : map.keySet()) {
                    result.add(new SubView<String>(parent, this, viewId, viewId, null, null));
                }
            }
        }
        Collator collator = Collator.getInstance(ClientLocale.getThreadLocale());
        result.sort((a, b) -> collator.compare(a.getDisplayName(), b.getDisplayName()));
        return result;
    }

    private void appendNotTokenizedSubViews(HashMap<String, SubView<?>> map, @Nonnull TicketViewFactory parent, TicketField<?> field, SearchTag searchTag, @Nonnull Set<Integer> ticketIDs) {
        TicketReaderForSystem reader = TicketManager.getReaderForSystem();
        IndexSearchEngine<Integer> engine = reader.getSearchEngine();
        Iterator it = engine.createEntryIterator(searchTag, true);
        while (it.hasNext() && map.size() < 100) {
            String displayName;
            String viewId;
            SubView<Object> subview;
            Integer ticketID;
            TicketVO ticket;
            Object val;
            Map.Entry entry = (Map.Entry)it.next();
            @Nonnull Set ids = (Set)entry.getValue();
            if (!TicketFieldSubViewGrouping.hasIntersection(ids, ticketIDs) || (val = (ticket = reader.getTicket(ticketID = (Integer)Collections.max(ids))).getValue(field)) == null || (subview = map.get(viewId = (displayName = val.toString()).toLowerCase())) != null) continue;
            subview = new SubView<String>(parent, this, viewId, displayName, null, null);
            map.put(viewId, subview);
        }
    }

    private static <T> boolean hasIntersection(@Nonnull Set<T> set1, @Nonnull Set<T> set2) {
        if (set1.size() < set2.size()) {
            for (T element : set1) {
                if (!set2.contains(element)) continue;
                return true;
            }
        } else {
            for (T element : set2) {
                if (!set1.contains(element)) continue;
                return true;
            }
        }
        return false;
    }
}

