/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.autotext;

import com.inet.helpdesk.config.autotext.data.AutoTextEntry;
import com.inet.helpdesk.config.autotext.handler.AutoTextAttachmentHelper;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class LoadAutoTextUtil {
    public static List<AutoTextEntry> getAutoTextEntries(String filter, String searchTerm) {
        ArrayList<AutoTextEntry> entries = new ArrayList<AutoTextEntry>();
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentUserAccount == null) {
            return entries;
        }
        AutoTextManager man = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        Set groupsForUser = new HashSet();
        groupsForUser = UserGroupManager.getInstance().getGroupsForUser(currentUserAccount.getID());
        boolean isAdminGroup = groupsForUser.contains(UserGroupManager.getInstance().getGroup(UsersAndGroups.GROUPID_ADMIN));
        boolean userIsAdmin = currentUserAccount.getAccountType().equals((Object)UserAccountType.Administrator);
        boolean userHasPermission = SystemPermissionChecker.hasAnyPermission((GUID)currentUserAccount.getID(), (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION, Permission.CONFIGURATION});
        Integer currentUserId = HDUsersAndGroups.getUserID(currentUserAccount.getID());
        for (AutoTextVO autoTextVO : switch (filter) {
            case "admin" -> {
                if (userIsAdmin || isAdminGroup) {
                    yield man.getConfigurableAutoTextsForUser(currentUserAccount.getID(), AutoTextManager.VisibilityFilter.IS_ADMIN);
                }
            }
            case "visible" -> man.getConfigurableAutoTextsForUser(currentUserAccount.getID(), AutoTextManager.VisibilityFilter.HAS_PERMISSION);
            default -> man.getConfigurableAutoTextsForUser(currentUserAccount.getID(), AutoTextManager.VisibilityFilter.IS_OWNER);
        }) {
            UserAccount userAccount;
            Object convertToPlainText;
            int sortPrio = LoadAutoTextUtil.matchFilter(searchTerm, autoTextVO);
            if (sortPrio <= 0) continue;
            Boolean hasAttachments = Boolean.FALSE;
            if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
                hasAttachments = !AutoTextAttachmentHelper.getAutoTextAttachments(autoTextVO.getId()).isEmpty();
            }
            if (((String)(convertToPlainText = TicketTextFunctions.convertToPlainText(autoTextVO.getContentText()))).length() > 500) {
                convertToPlainText = ((String)convertToPlainText).substring(0, 497) + "...";
            }
            GUID userGUID = null;
            if (autoTextVO.getUserId() != null && (userAccount = HDUsersAndGroups.getUserAccount(autoTextVO.getUserId())) != null) {
                userGUID = userAccount.getID();
            }
            Integer id = autoTextVO.getId();
            String label = autoTextVO.getLabel();
            Integer userId = autoTextVO.getUserId();
            String shortcut = autoTextVO.getShortcut();
            Integer typ = autoTextVO.getTyp();
            String groupLabel = autoTextVO.getGroupLabel();
            Boolean isSignature = autoTextVO.isEmailSignature();
            Boolean isPrivate = autoTextVO.getMemberships() == null;
            Boolean isEditable = userIsAdmin || isAdminGroup || userHasPermission || Objects.equals(currentUserId, autoTextVO.getUserId());
            AutoTextEntry e = new AutoTextEntry(id, label, userId, userGUID, shortcut, typ, groupLabel, hasAttachments, (String)convertToPlainText, isSignature, isPrivate, isEditable);
            e.setSortId(sortPrio);
            entries.add(e);
        }
        return entries;
    }

    private static int matchFilter(String filter, AutoTextVO autoText) {
        if (filter == null) {
            return 1;
        }
        String matchTerm = filter.toLowerCase();
        if (autoText.getDisplayValue() != null && autoText.getDisplayValue().toLowerCase().indexOf(matchTerm) > -1) {
            return 30;
        }
        if (autoText.getContentText() != null && autoText.getContentText().toLowerCase().indexOf(matchTerm) > -1) {
            return 20;
        }
        if (autoText.getGroupLabel() != null && autoText.getGroupLabel().toLowerCase().indexOf(matchTerm) > -1) {
            return 10;
        }
        if (autoText.getShortcut() != null && autoText.getShortcut().toLowerCase().indexOf(matchTerm) > -1) {
            return 10;
        }
        return 0;
    }
}

