/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigKey;
import com.inet.config.structure.model.BooleanConfigProperty;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.StyledLabelConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.EmailAccountSaver;
import com.inet.helpdesk.config.EmailProtocol;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LocalizedKeyListFactory;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.mail.api.MailAuthenticationMethod;
import com.inet.mail.api.profiles.MailProfile;
import com.inet.oauth.connection.api.config.OAuthConnectionTokenConfigProperty;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ProxyHttpServletRequest;
import com.inet.usersandgroups.api.user.UserAccount;
import jakarta.mail.Folder;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.mail.AutoMail;
import srv.mail.MailConnectionCreator;

@JsonData
class EmailAccountListConfigProperty
extends ItemListConfigProperty {
    private static final String ID = "id";
    private static final String PROVIDER = "provider";
    private static final String PROVIDER_DISPLAY_NAME = "providerDisplayName";
    private static final String REFRESH_TOKEN = "refreshToken";
    private static final String PROFILE_SCOPE = "profileScope";
    private static final String PROFILE_PROVIDER = "profileProvider";
    private static final String ACCOUNT = "account";
    private static final String HOST = "host";
    private static final String PROTOCOL = "protocol";
    private static final String FROM_NAME = "fromName";
    private static final String FROM = "from";
    private static final String PASSWORD = "password";
    private static final String ACCOUNT_EMAIL = "accountEmail";
    private static final String PREVENT_PLAIN_AUTH = "preventPlainAuth";
    private static final String PREVENT_NTLM_AUTH = "preventNtlmAuth";
    private static final String SSL_SUFFIX = " + SSL";
    public static final String FALLBACK_OWNER = "fallbackOwner";
    public static final String ONLY_EXISTING_TICKETS = "onlyExistingTickets";
    private static final String ERR_BAD_PUBLIC_URL = "mail.error.badPublicUrl";

    EmailAccountListConfigProperty(int sortId, boolean advanced, ConfigStructureSettings settings, ConnectionFactory connectionFactory, Translator translator) {
        super(sortId, HDConfigKeys.MAIL_ACCOUNTS.getKey(), "MAIL_ACCOUNTS", EmailAccountListConfigProperty.getObjectListValue(settings, translator), translator.translate("mailaccounts.add.new"), new ConfigRowAction[]{EmailAccountListConfigProperty.getRowAction(advanced, settings, connectionFactory, translator)});
    }

    static Object getObjectListValue(ConfigStructureSettings settings, Translator translator) {
        String valueStr = settings.getOriginalValue(HDConfigKeys.MAIL_ACCOUNTS);
        EmailAccountList originalEmailAccountList = (EmailAccountList)new Json().fromJson(valueStr, EmailAccountList.class, new HashMap());
        for (EmailAccount ea : originalEmailAccountList) {
            MailProfile sendProfile;
            String provider = ea.getProvider();
            String refreshToken = ea.getRefreshToken();
            if (StringFunctions.isEmpty((String)provider) || StringFunctions.isEmpty((String)refreshToken) || (sendProfile = MailProfile.getProfile((String)provider)) == null) continue;
            try {
                OauthAccessTokenManager.getAccessToken((String)sendProfile.getOauthProvider(), (String)refreshToken, (int)1800, (Consumer)new EmailAccountSaver(ea));
            }
            catch (Throwable throwable) {}
        }
        HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.MAIL_ACCOUNTS, HashMap[].class);
        if (changedValue != null) {
            for (HashMap account : changedValue) {
                MailProfile profile;
                Integer validationHashCode = null;
                try {
                    validationHashCode = Integer.parseInt((String)account.get("validationHashCode"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EmailAccount ea = EmailAccountListConfigProperty.toEmailAccount(account, translator, originalEmailAccountList);
                ea.setErrorMessage(null);
                int currentValidationHashCode = ea.hashCode();
                if (validationHashCode != null && validationHashCode == currentValidationHashCode) continue;
                account.put("validationHashCode", String.valueOf(currentValidationHashCode));
                if (MailProfile.XOAUTH2 && (profile = MailProfile.getProfile((String)ea.getProvider())) != null) {
                    account.put(PROVIDER_DISPLAY_NAME, profile.getDisplayName());
                }
                String errorMsg = EmailAccountListConfigProperty.checkEmailAccountConnection(ea);
                account.put("errorMessage", errorMsg);
            }
            return changedValue;
        }
        return EmailAccountListConfigProperty.convertAccountsToHashMaps(originalEmailAccountList, translator);
    }

    static EmailAccount toEmailAccount(HashMap<String, String> entry, Translator translator, @Nonnull EmailAccountList originalEmailAccountList) {
        String onlyExistingTicketsValue;
        LocalizedKey fallbackOwner;
        EmailAccount original;
        HashMap<String, EmailAccount> originalAccounts = new HashMap<String, EmailAccount>();
        for (EmailAccount ea : originalEmailAccountList) {
            originalAccounts.put(ea.getID(), ea);
        }
        EmailAccountListConfigProperty.setPortForProtocol(entry);
        EmailAccount ea = new EmailAccount();
        String id = entry.get(ID);
        if (StringFunctions.isEmpty((String)id)) {
            id = GUID.generateNew().toString();
        }
        ea.setId(id);
        ea.setProvider(entry.get(PROVIDER));
        String refreshToken = entry.get(REFRESH_TOKEN);
        if ("xxxxxx".equals(refreshToken) && (original = (EmailAccount)originalAccounts.get(id)) != null) {
            refreshToken = original.getRefreshToken();
        }
        ea.setRefreshToken(refreshToken);
        ea.setAccount(entry.get(ACCOUNT));
        try {
            String categoryPath = entry.get("category");
            Integer categoryId = CategoryManager.getInstance().findOrCreateCategory(categoryPath, true);
            ea.setCategoryId(categoryId);
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        ea.setErrorMessage(entry.get("errorMessage"));
        ea.setCreateDomain("true".equals(entry.get("createDomain")));
        ea.setFrom(entry.get(FROM));
        ea.setFromName(entry.get(FROM_NAME));
        ea.setAccountEmailAddress(entry.get(ACCOUNT_EMAIL));
        ea.setHost(entry.get(HOST));
        ea.setNewUser("true".equals(entry.get("newUser")));
        ea.setNoBundles(Boolean.valueOf(entry.get("bundles")) != false ? "" : "*");
        ea.setPasswordDecoded(entry.get(PASSWORD));
        String priority = entry.get("priority");
        ea.setPriority(priority.isEmpty() ? 0 : Integer.parseInt(priority));
        String protocol = entry.get(PROTOCOL);
        EmailAccountListConfigProperty.setEmailAccountProtocolAndSsl(ea, protocol);
        ea.setPort(entry.get("port"));
        EmailAccountListConfigProperty.setPortForProtocol(entry);
        String resID = entry.get("resID");
        int resIDNum = resID == null || resID.isEmpty() ? 0 : Integer.parseInt(resID);
        resIDNum = Math.abs(resIDNum);
        ea.setResID(resIDNum);
        ea.setTemplate(EmailAccountListConfigProperty.putAccountTemplate(entry.get("template"), translator));
        ea.setPreventPlainAuth("true".equals(entry.get(PREVENT_PLAIN_AUTH)));
        ea.setPreventNtlmAuth("true".equals(entry.get(PREVENT_NTLM_AUTH)));
        String fallbackOwnerValue = entry.get(FALLBACK_OWNER);
        if (!StringFunctions.isEmpty((String)fallbackOwnerValue) && !StringFunctions.isEmpty((String)(fallbackOwner = (LocalizedKey)new Json().fromJson(fallbackOwnerValue, LocalizedKey.class)).getKey())) {
            ea.setFallbackOwnerGUID(GUID.valueOf((String)fallbackOwner.getKey()));
        }
        if (!StringFunctions.isEmpty((String)(onlyExistingTicketsValue = entry.get(ONLY_EXISTING_TICKETS)))) {
            Boolean onlyExistingTickets = Boolean.valueOf(onlyExistingTicketsValue);
            ea.setOnlyAcceptEmailsForExistingTickets(onlyExistingTickets);
        }
        return ea;
    }

    static ArrayList<HashMap<String, String>> convertAccountsToHashMaps(EmailAccountList accounts, Translator translator) {
        accounts.sort((o1, o2) -> {
            String acc1 = o1.getAccount() == null ? "" : o1.getAccount();
            String acc2 = o2.getAccount() == null ? "" : o2.getAccount();
            return acc1.compareToIgnoreCase(acc2);
        });
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        for (EmailAccount ea : accounts) {
            UserAccount userAccount;
            MailProfile profile;
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put(ID, ea.getID());
            String provider = ea.getProvider();
            if (MailProfile.XOAUTH2 && (profile = MailProfile.getProfile((String)provider)) != null) {
                entry.put(PROVIDER_DISPLAY_NAME, profile.getDisplayName());
                entry.put(PROFILE_SCOPE, profile.getImapScopes());
                entry.put(PROFILE_PROVIDER, profile.getOauthProvider());
            }
            entry.put(PROVIDER, provider);
            entry.put(REFRESH_TOKEN, StringFunctions.isEmpty((String)ea.getRefreshToken()) ? "" : "xxxxxx");
            entry.put(ACCOUNT, ea.getAccount());
            entry.put(PASSWORD, ea.getPasswordDecoded());
            entry.put(FROM, ea.getFrom());
            entry.put("errorMessage", ea.getErrorMessage());
            entry.put(FROM_NAME, ea.getFromName());
            entry.put(ACCOUNT_EMAIL, ea.getAccountEmailAddress());
            try {
                Integer categoryId = ea.getCategoryId();
                String categoryPath = CategoryManager.getInstance().findCategoryPathOrThrow(categoryId);
                entry.put("category", categoryPath);
            }
            catch (ServerDataException e) {
                HDLogger.error(e);
                entry.put("category", "");
            }
            entry.put("bundles", "" + (ea.getNoBundles() == null || ea.getNoBundles().isEmpty()));
            entry.put("template", EmailAccountListConfigProperty.getAccountTemplate(ea.getTemplate(), translator));
            entry.put(HOST, ea.getHost());
            entry.put("port", ea.getPort() > 0 ? String.valueOf(ea.getPort()) : "");
            entry.put("ssl", String.valueOf(ea.getSSL()));
            if (ea.getSSL()) {
                entry.put(PROTOCOL, ea.getProtocol().name() + SSL_SUFFIX);
            } else {
                entry.put(PROTOCOL, ea.getProtocol().name());
            }
            entry.put("portIMAP", "");
            entry.put("portIMAPSSL", "");
            entry.put("portPOP3", "");
            entry.put("portPOP3SSL", "");
            entry.put(EmailAccountListConfigProperty.portFieldForProtocol((String)entry.get(PROTOCOL)), (String)entry.get("port"));
            entry.put("createDomain", String.valueOf(ea.getCreateDomain()));
            entry.put("newUser", String.valueOf(ea.getNewUser()));
            entry.put("priority", String.valueOf(ea.getPriority()));
            entry.put("resID", String.valueOf(ea.getResID()));
            entry.put("titlelabel", "");
            entry.put("titlelabel2", "");
            entry.putIfAbsent(ERR_BAD_PUBLIC_URL, "");
            entry.putIfAbsent(PROFILE_PROVIDER, "");
            entry.putIfAbsent(PROFILE_SCOPE, "");
            entry.put("onlyExistingTickets.labelkey", translator.translate("onlyExistingTickets.label"));
            entry.put("onlyExistingTickets.labelkeysimple", translator.translate("onlyExistingTickets.labelsimple"));
            entry.put(PREVENT_PLAIN_AUTH, String.valueOf(ea.getPreventPlainAuth()));
            entry.put(PREVENT_NTLM_AUTH, String.valueOf(ea.getPreventNtlmAuth()));
            GUID fallbackOwnerGUID = ea.getFallbackOwnerGUID();
            LocalizedKey fallbackOwner = new LocalizedKey("", translator.translate("fallbackOwner.none"));
            if (fallbackOwnerGUID != null && (userAccount = HelpDeskUserManager.getRecoveryEnabledInstance().getUserAccount(fallbackOwnerGUID)) != null) {
                fallbackOwner = new LocalizedKey(fallbackOwnerGUID.toString(), userAccount.getDisplayName());
            }
            entry.put(FALLBACK_OWNER, new Json().toJson((Object)fallbackOwner));
            boolean onlyAcceptEmailsForExistingTickets = ea.isOnlyAcceptEmailsForExistingTickets();
            entry.put(ONLY_EXISTING_TICKETS, String.valueOf(onlyAcceptEmailsForExistingTickets));
            String errorMessage = ea.getErrorMessage();
            ea.setErrorMessage(null);
            entry.put("validationHashCode", String.valueOf(ea.hashCode()));
            ea.setErrorMessage(errorMessage);
            result.add(entry);
        }
        return result;
    }

    private static String getAccountTemplate(String templateName, Translator translator) {
        if (templateName != null && templateName.length() > 0) {
            return templateName;
        }
        return translator.translate("noTemplate");
    }

    private static String putAccountTemplate(String templateName, Translator translator) {
        if (translator.translate("noTemplate").equals(templateName)) {
            return "";
        }
        return templateName;
    }

    private static void setPortForProtocol(HashMap<String, String> account) {
        if (account.get(PROTOCOL) != null) {
            String protocol = account.get(PROTOCOL);
            String portField = EmailAccountListConfigProperty.portFieldForProtocol(protocol);
            String portValueString = account.get(portField);
            if (portField != null && portValueString != null && !portValueString.equals("null")) {
                account.put("port", portValueString);
            }
            Iterator<Map.Entry<String, String>> it = account.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                if (!"null".equals(e.getValue())) continue;
                it.remove();
            }
        }
    }

    static String portFieldForProtocol(String protocol) {
        String portField = null;
        switch (protocol) {
            case "IMAP": {
                portField = "portIMAP";
                break;
            }
            case "IMAP + SSL": {
                portField = "portIMAPSSL";
                break;
            }
            case "POP3": {
                portField = "portPOP3";
                break;
            }
            case "POP3 + SSL": {
                portField = "portPOP3SSL";
                break;
            }
        }
        return portField;
    }

    static EmailAccountList convertToList(String value, Translator translator, @Nonnull EmailAccountList originalEmailAccountList) {
        HashMap[] result = (HashMap[])new Json().fromJson(value, HashMap[].class);
        EmailAccountList list = new EmailAccountList();
        for (HashMap entry : result) {
            EmailAccount ea = EmailAccountListConfigProperty.toEmailAccount(entry, translator, originalEmailAccountList);
            list.add(ea);
        }
        list.sort((o1, o2) -> {
            String acc1 = o1.getAccount() == null ? "" : o1.getAccount();
            String acc2 = o2.getAccount() == null ? "" : o2.getAccount();
            return acc1.compareToIgnoreCase(acc2);
        });
        return list;
    }

    static void setEmailAccountProtocolAndSsl(EmailAccount ea, String protocol) {
        if (protocol.endsWith(SSL_SUFFIX)) {
            protocol = protocol.substring(0, protocol.length() - SSL_SUFFIX.length());
            ea.setSSL(true);
        } else {
            ea.setSSL(false);
        }
        ea.setProtocol(protocol);
    }

    private static ConfigRowAction getRowAction(boolean advanced, ConfigStructureSettings settings, ConnectionFactory connectionFactory, final Translator translator) {
        ConfigAction action = new ConfigAction("emailaccount.new", translator.translate("AddEmailAccount"));
        ConfigCategory category = new ConfigCategory(0, "emailaccount.new", translator.translate("EmailAccount"), "new-email-account");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "titlelabel", ""));
        propertyGroups.add(new ConfigPropertyGroup(1, "emailaccount.new.maileingang", translator.translate("Maileingang")));
        propertyGroups.add(new ConfigPropertyGroup(2, "emailaccount.new.anmeldeInfo", translator.translate("AnmeldeInfo")));
        propertyGroups.add(new ConfigPropertyGroup(3, "emailaccount.new.accountInfo", translator.translate("AccountInfo")));
        propertyGroups.add(new ConfigPropertyGroup(4, "emailaccount.new.ticketerstellung", translator.translate("Ticketerstellung")));
        propertyGroups.add(new ConfigPropertyGroup(5, "helpdesk.testemail", translator.translate("helpdesk.testemail.title"), new ConfigAction("helpdesk.testemail", translator.translate("helpdesk.testemail"))));
        HashMap properties = new HashMap();
        ArrayList<ConfigProperty> accountInfo = new ArrayList<ConfigProperty>();
        ArrayList<Object> anmeldeInfo = new ArrayList<Object>();
        ArrayList<Object> maileingang = new ArrayList<Object>();
        ArrayList<Object> ticketerstellung = new ArrayList<Object>();
        properties.put("titlelabel", new ArrayList<ConfigProperty>(){
            {
                this.add(EmailAccountListConfigProperty.propWith("Label", translator.translate("EmailKonten.title_label"), "titlelabel", null, null));
                this.add(new StyledLabelConfigProperty(Set.of(StyledLabelConfigProperty.Style.bold, StyledLabelConfigProperty.Style.danger), 0, "titlelabel2", translator.translate("EmailKonten.title_label2")));
            }
        });
        properties.put("emailaccount.new.accountInfo", accountInfo);
        properties.put("emailaccount.new.anmeldeInfo", anmeldeInfo);
        properties.put("emailaccount.new.maileingang", maileingang);
        properties.put("emailaccount.new.ticketerstellung", ticketerstellung);
        properties.put("helpdesk.testemail", new ArrayList());
        List profiles = null;
        if (MailProfile.XOAUTH2 && (profiles = MailProfile.getAvailableProfiles()).size() > 0) {
            maileingang.add(EmailAccountListConfigProperty.propWith("Hidden", null, PROFILE_SCOPE, "", null));
            maileingang.add(EmailAccountListConfigProperty.propWith("Hidden", null, PROFILE_PROVIDER, "", null));
            ArrayList<LocalizedKey> options = new ArrayList<LocalizedKey>();
            options.add(new LocalizedKey("", translator.translate("customMailServer")));
            for (MailProfile profile : profiles) {
                options.add(new LocalizedKey(profile.getName(), profile.getDisplayName()));
            }
            maileingang.add(new SelectConfigProperty(0, PROVIDER, "SimpleText", translator.translate(PROVIDER), (Object)"", null, options));
            String currentServerPort = ProxyHttpServletRequest.getHttpServerPort((HttpServletRequest)SessionStore.getHttpServletRequest()).toString();
            String publicServerPort = OauthAccessTokenManager.getRedirectUrl();
            int idx = publicServerPort.indexOf("://") + 3;
            idx = publicServerPort.indexOf(47, idx);
            if (idx > 0) {
                publicServerPort = publicServerPort.substring(0, idx);
            }
            if (!currentServerPort.equalsIgnoreCase(publicServerPort)) {
                maileingang.add(new StyledLabelConfigProperty(Set.of(StyledLabelConfigProperty.Style.danger), 104, ERR_BAD_PUBLIC_URL, "", translator.translate(ERR_BAD_PUBLIC_URL, publicServerPort)));
            } else {
                maileingang.add(EmailAccountListConfigProperty.propWith("Hidden", null, ERR_BAD_PUBLIC_URL, "", null));
            }
            HashMap<String, String> additionalOAuthParameter = new HashMap<String, String>();
            additionalOAuthParameter.put(PROVIDER, PROFILE_PROVIDER);
            additionalOAuthParameter.put("scope", PROFILE_SCOPE);
            maileingang.add(new OAuthConnectionTokenConfigProperty(105, REFRESH_TOKEN, "", additionalOAuthParameter));
        }
        ArrayList<ConfigConditionAction> conditions = EmailAccountListConfigProperty.generateConditionActions(advanced, profiles);
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        maileingang.add(EmailAccountListConfigProperty.propWith("Hidden", null, ID, "", null));
        maileingang.add(EmailAccountListConfigProperty.propWith("Hidden", null, "ssl", "false", null));
        accountInfo.add(EmailAccountListConfigProperty.propWith("SimpleText", translator.translate("Name"), FROM_NAME, "", null));
        accountInfo.add(EmailAccountListConfigProperty.propWith("SimpleText", translator.translate("SenderEmailAdresse"), FROM, "", null));
        accountInfo.add(EmailAccountListConfigProperty.propWith("SimpleText", translator.translate("AccountEmailAdresse"), ACCOUNT_EMAIL, "", null));
        maileingang.add(EmailAccountListConfigProperty.propWith("SimpleText", translator.translate("MailHost"), HOST, settings.getValue(ConfigKey.MAIL_SMTPHOST), null));
        anmeldeInfo.add(EmailAccountListConfigProperty.propWith("SimpleText", translator.translate("User"), ACCOUNT, "", translator.translate("User.placeholder")));
        anmeldeInfo.add(EmailAccountListConfigProperty.propWith("Password", translator.translate("Passwort"), PASSWORD, "", null));
        anmeldeInfo.add(new BooleanConfigProperty(0, PREVENT_PLAIN_AUTH, "Boolean", translator.translate("PlainAuthentiction"), null, null, (Object)String.valueOf(true)));
        anmeldeInfo.add(new BooleanConfigProperty(0, PREVENT_NTLM_AUTH, "Boolean", translator.translate("NtlmAuthentiction"), null, null, (Object)String.valueOf(false)));
        SelectConfigProperty protocols = new SelectConfigProperty(123, PROTOCOL, "SimpleText", translator.translate("Protokoll"), (Object)"", "", (List)new ArrayList<LocalizedKey>(){
            {
                this.add(new LocalizedKey(EmailProtocol.IMAP.name(), EmailProtocol.IMAP.name()));
                this.add(new LocalizedKey(EmailProtocol.IMAP.name() + EmailAccountListConfigProperty.SSL_SUFFIX, EmailProtocol.IMAP.name() + EmailAccountListConfigProperty.SSL_SUFFIX));
                this.add(new LocalizedKey(EmailProtocol.POP3.name(), EmailProtocol.POP3.name()));
                this.add(new LocalizedKey(EmailProtocol.POP3.name() + EmailAccountListConfigProperty.SSL_SUFFIX, EmailProtocol.POP3.name() + EmailAccountListConfigProperty.SSL_SUFFIX));
            }
        });
        maileingang.add(protocols);
        maileingang.add(EmailAccountListConfigProperty.propWith("FixNumber", translator.translate("Port"), "portIMAP", settings.getValue("PortIMAP"), "143"));
        maileingang.add(EmailAccountListConfigProperty.propWith("FixNumber", translator.translate("Port"), "portIMAPSSL", settings.getValue("PortIMAPSSL"), "993"));
        maileingang.add(EmailAccountListConfigProperty.propWith("FixNumber", translator.translate("Port"), "portPOP3", settings.getValue("PortPOP3"), "110"));
        maileingang.add(EmailAccountListConfigProperty.propWith("FixNumber", translator.translate("Port"), "portPOP3SSL", settings.getValue("PortPOP3SSL"), "995"));
        ticketerstellung.add(new BooleanConfigProperty(0, ONLY_EXISTING_TICKETS, "Boolean", translator.translate(ONLY_EXISTING_TICKETS), null, null, (Object)String.valueOf(false)));
        ticketerstellung.add(new ConfigProperty(ticketerstellung.size() * 100, "onlyExistingTickets.labelkey", "KeyLabel", "", null, null, null));
        ticketerstellung.add(new ConfigProperty(ticketerstellung.size() * 100, "onlyExistingTickets.labelkeysimple", "KeyLabel", "", null, null, null));
        List<LocalizedKey> resourceList = LocalizedKeyListFactory.getResources();
        resourceList.add(0, new LocalizedKey("", ""));
        SelectConfigProperty resources = new SelectConfigProperty(123, "resID", "FixNumber", translator.translate("EmailsGehenAn"), (Object)"", "", resourceList);
        ticketerstellung.add(resources);
        ServerValuesConnector svc = (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
        List<LocalizedKey> options = LocalizedKeyListFactory.getCategories(svc);
        HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.MAIL_ACCOUNTS, HashMap[].class);
        if (changedValue != null) {
            Arrays.asList(changedValue).stream().map(map -> (String)map.get("category")).filter(cat -> !options.stream().map(l -> l.getKey()).anyMatch(catpath -> catpath.equals(cat))).map(cat -> new LocalizedKey(cat, cat)).forEach(l -> options.add((LocalizedKey)l));
        } else {
            String valueStr = settings.getValue(HDConfigKeys.MAIL_ACCOUNTS);
            EmailAccountList emailAccountList = (EmailAccountList)new Json().fromJson(valueStr, EmailAccountList.class, new HashMap());
            for (EmailAccount ea : emailAccountList) {
                Integer id = ea.getCategoryId();
                CategoryVO cat2 = id != null ? (CategoryVO)CategoryManager.getInstance().get(id) : null;
                if (cat2 == null || options.stream().map(l -> l.getKey()).anyMatch(catpath -> catpath.equals(cat2.getPath()))) continue;
                LocalizedKey l2 = new LocalizedKey(cat2.getPath(), cat2.getPath());
                options.add(l2);
            }
            options.sort((o1, o2) -> CategoryVO.comparePaths(o1.getKey(), o2.getKey()));
        }
        SelectConfigProperty categories = new SelectConfigProperty(123, "category", "SimpleText", translator.translate("Kategorie"), (Object)"", "", options);
        ticketerstellung.add(categories);
        if (!settings.isFilter()) {
            List<LocalizedKey> priorityList = LocalizedKeyListFactory.getPriorities(connectionFactory);
            priorityList.add(0, new LocalizedKey("", ""));
            SelectConfigProperty priorities = new SelectConfigProperty(123, "priority", "FixNumber", translator.translate("Priorit\u00e4t"), (Object)"", "", priorityList);
            ticketerstellung.add(priorities);
        }
        ticketerstellung.add(new BooleanConfigProperty(0, "newUser", "Boolean", translator.translate("NeueNutzer"), null, null, (Object)String.valueOf(true)));
        ticketerstellung.add(new BooleanConfigProperty(0, "createDomain", "Boolean", translator.translate("Dom\u00e4neNutzen"), null, null, (Object)String.valueOf(true)));
        ticketerstellung.add(new ConfigProperty(0, FALLBACK_OWNER, "SelectFiltered", translator.translate("FallbackOwner"), (Object)new Json().toJson((Object)new LocalizedKey("", translator.translate("fallbackOwner.none"))), null, null));
        ticketerstellung.add(new BooleanConfigProperty(0, "bundles", "Boolean", translator.translate("NonBundle"), null, null, (Object)String.valueOf(false)));
        String[] files = AutoMail.availableTemplateNames();
        String[] withEmpty = new String[files.length + 1];
        withEmpty[0] = EmailAccountListConfigProperty.getAccountTemplate("", translator);
        System.arraycopy(files, 0, withEmpty, 1, files.length);
        List templateValues = Arrays.asList(withEmpty).stream().filter(name -> name != null && name.length() > 0).map(name -> new LocalizedKey(name, name)).collect(Collectors.toList());
        SelectConfigProperty templates = new SelectConfigProperty(123, "template", "SimpleText", translator.translate("Template"), (Object)"", translator.translate("Template.tooltip"), templateValues);
        ticketerstellung.add(templates);
        return rowAction;
    }

    private static ArrayList<ConfigConditionAction> generateConditionActions(boolean advanced, @Nullable List<MailProfile> profiles) {
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        ConfigCondition c = g.createCondition().property("newUser").equals().value((Object)true);
        ConfigConditionAction cca = new ConfigConditionAction(ConfigConditionAction.Action.Enable, "createDomain", c);
        conditions.add(cca);
        ConfigCondition imapSsl = g.createCondition().property(PROTOCOL).equals().value((Object)(EmailProtocol.IMAP.name() + SSL_SUFFIX));
        ConfigCondition pop3Ssl = g.createCondition().property(PROTOCOL).equals().value((Object)(EmailProtocol.POP3.name() + SSL_SUFFIX));
        ConfigCondition imap = g.createCondition().property(PROTOCOL).equals().value((Object)EmailProtocol.IMAP.name());
        ConfigCondition pop3 = g.createCondition().property(PROTOCOL).equals().value((Object)EmailProtocol.POP3.name());
        ConfigCondition flags = advanced ? null : g.alwaysFalse();
        ConfigCondition sslCondition = g.createCondition().or(new ConfigCondition[]{imapSsl, pop3Ssl});
        ConfigConditionAction ccSsl = new ConfigConditionAction(ConfigConditionAction.Action.SetValue, "ssl", sslCondition, "true");
        ConfigConditionAction ccSslFalse = new ConfigConditionAction(ConfigConditionAction.Action.SetValue, "ssl", g.createCondition().not(sslCondition), "false");
        conditions.add(ccSsl);
        conditions.add(ccSslFalse);
        if (MailProfile.XOAUTH2 && profiles != null && profiles.size() > 0) {
            ConfigCondition custom = g.createCondition().property(PROVIDER).equals().value((Object)"");
            conditions.add(g.visibleActionFor(custom, HOST));
            conditions.add(g.visibleActionFor(custom, PASSWORD));
            conditions.add(g.visibleActionFor(custom, PROTOCOL));
            flags = custom;
            imapSsl = g.createCondition().and(new ConfigCondition[]{custom, imapSsl});
            pop3Ssl = g.createCondition().and(new ConfigCondition[]{custom, pop3Ssl});
            imap = g.createCondition().and(new ConfigCondition[]{custom, imap});
            pop3 = g.createCondition().and(new ConfigCondition[]{custom, pop3});
            ConfigCondition oauthRefresh = custom;
            for (MailProfile profile : profiles) {
                ConfigCondition cond = g.createCondition().property(PROVIDER).equals().value((Object)profile.getName());
                conditions.add(g.setValueActionFor(cond, PROFILE_SCOPE, profile.getImapScopes()));
                conditions.add(g.setValueActionFor(cond, PROFILE_PROVIDER, profile.getOauthProvider()));
                if (profile.getAuthenticationMethod() == MailAuthenticationMethod.XOAUTH2) continue;
                oauthRefresh = g.createCondition().or(new ConfigCondition[]{custom, cond});
            }
            oauthRefresh = g.createCondition().not(oauthRefresh);
            conditions.add(g.visibleActionFor(oauthRefresh, REFRESH_TOKEN));
            conditions.add(g.visibleActionFor(oauthRefresh, ERR_BAD_PUBLIC_URL));
            conditions.add(g.setValueActionFor(custom, PROFILE_SCOPE, ""));
            conditions.add(g.setValueActionFor(custom, PROFILE_PROVIDER, ""));
        }
        conditions.add(g.visibleActionFor(imap, "portIMAP"));
        conditions.add(g.visibleActionFor(imapSsl, "portIMAPSSL"));
        conditions.add(g.visibleActionFor(pop3, "portPOP3"));
        conditions.add(g.visibleActionFor(pop3Ssl, "portPOP3SSL"));
        ConfigCondition noNewUsers = g.createCondition().property("newUser").equals().value((Object)false);
        ConfigCondition allowsNewUsers = g.createCondition().property("newUser").equals().value((Object)true);
        ConfigCondition allowsNewTickets = g.createCondition().property(ONLY_EXISTING_TICKETS).equals().value((Object)false);
        ConfigCondition noNewTickets = g.createCondition().property(ONLY_EXISTING_TICKETS).equals().value((Object)true);
        ConfigCondition showFallbackOwner = g.createCondition().and(new ConfigCondition[]{noNewUsers, allowsNewTickets});
        conditions.add(g.enableActionFor(showFallbackOwner, FALLBACK_OWNER));
        conditions.add(g.enableActionFor(allowsNewTickets, "resID"));
        conditions.add(g.enableActionFor(allowsNewTickets, "category"));
        conditions.add(g.enableActionFor(allowsNewTickets, "priority"));
        conditions.add(g.enableActionFor(allowsNewTickets, "newUser"));
        conditions.add(g.enableActionFor(g.createCondition().and(new ConfigCondition[]{allowsNewTickets, allowsNewUsers}), "createDomain"));
        conditions.add(g.enableActionFor(allowsNewTickets, "bundles"));
        conditions.add(g.enableActionFor(allowsNewTickets, "template"));
        if (!advanced) {
            conditions.add(g.visibleActionFor(g.alwaysFalse(), "onlyExistingTickets.labelkey"));
            conditions.add(g.visibleActionFor(noNewTickets, "onlyExistingTickets.labelkeysimple"));
            conditions.add(g.visibleActionFor(g.alwaysFalse(), ONLY_EXISTING_TICKETS));
            conditions.add(g.visibleActionFor(g.alwaysFalse(), FALLBACK_OWNER));
            conditions.add(g.visibleActionFor(g.alwaysFalse(), "newUser"));
            conditions.add(g.visibleActionFor(g.alwaysFalse(), "createDomain"));
            conditions.add(g.visibleActionFor(g.alwaysFalse(), "template"));
            conditions.add(g.visibleActionFor(g.alwaysFalse(), "bundles"));
        } else {
            conditions.add(g.visibleActionFor(noNewTickets, "onlyExistingTickets.labelkey"));
            conditions.add(g.visibleActionFor(g.alwaysFalse(), "onlyExistingTickets.labelkeysimple"));
        }
        if (flags != null) {
            conditions.add(g.visibleActionFor(flags, PREVENT_PLAIN_AUTH));
            conditions.add(g.visibleActionFor(flags, PREVENT_NTLM_AUTH));
        }
        return conditions;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, placeholder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String checkEmailAccountConnection(@Nonnull EmailAccount account) {
        MailConnectionCreator.SessionStoreStatus status = new MailConnectionCreator.SessionStoreStatus();
        try {
            Folder folder = MailConnectionCreator.getConnectedFolder(account, status, 5000, 5000);
            if (folder != null) {
                folder.close();
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            String string = message == null ? e.toString() : message;
            return string;
        }
        finally {
            try {
                if (status.getStore() != null && status.getStore().isConnected()) {
                    status.getStore().close();
                }
            }
            catch (Throwable mex) {
                HDLogger.error(mex);
            }
        }
        return "";
    }
}

