/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Set;
import javax.annotation.Nullable;
import srv.mail.Mail;

public class AutoMailSender {
    private static final ConfigValue<Boolean> MAIL_AUTORISIERUNG_USER = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_USER);
    private static final ConfigValue<Boolean> MAIL_BEENDEN_USER = new ConfigValue(HDConfigKeys.MAIL_BEENDEN_USER);

    public static void sendIfNeeded(int ticketID, int mailType, @Nullable UserAccount producer) {
        String producerEmail = AutoMailSender.getEmailFrom(producer);
        AutoMailSender.sendIfNeeded(ticketID, mailType, producerEmail);
    }

    public static void sendIfNeeded(int ticketID, int mailType, @Nullable String producerEmail) {
        if (mailType > 0) {
            Mail.send(mailType, ticketID, producerEmail);
        }
    }

    public static void sendAutoMailAndNotifyResourceIfNeeded(int ticketID, int mailType, @Nullable UserAccount producer) {
        String producerEmail = AutoMailSender.getEmailFrom(producer);
        AutoMailSender.sendIfNeeded(ticketID, mailType, producerEmail);
        if (mailType == 2 || mailType == 9 || mailType == 15 || mailType == 14 || mailType == 3 || mailType == 10) {
            int producerID = HDUsersAndGroups.getUserID(producer);
            TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketID);
            if (ticket == null) {
                return;
            }
            GUID resourceID = ticket.getResourceID();
            if (resourceID != null) {
                Set<GUID> memberIDs = HDUsersAndGroups.getMembersInResource(resourceID, HDUsersAndGroups.RESOURCE_MEMBERSHIPTYPE_WRITE);
                for (GUID memberID : memberIDs) {
                    int id = HDUsersAndGroups.getUserID(memberID);
                    if (id == producerID) continue;
                    AutoMailSender.sendNotificationToActiveUser(UserManager.getInstance().getUserAccount(memberID), ticket);
                }
            }
        }
    }

    private static void sendNotificationToActiveUser(UserAccount user, TicketVO ticketVO) {
        WebSocketEventHandler eventHandler = WebSocketEventHandler.getInstance();
        if (eventHandler.getConnectionsForUser(user.getID()).size() > 0) {
            GUID ownerID;
            CategoryVO categoryVO;
            Object title = ticketVO.getSubject();
            if (((String)title).length() > 30) {
                title = ((String)title).substring(0, 27) + "...";
            }
            GUID resourceID = ticketVO.getResourceID();
            UserGroupInfo res = UserGroupManager.getInstance().getGroup(resourceID);
            Integer msgFlag = (Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_NOTIF_SETTINGS);
            if (msgFlag == null || (msgFlag & 0xC) == 0) {
                return;
            }
            String resourceName = res == null ? "" : res.getDisplayName();
            Integer categoryID = ticketVO.getCategoryID();
            String catName = "";
            if (categoryID != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(categoryID)) != null) {
                catName = categoryVO.getDisplayValue();
            }
            String ownerName = (ownerID = ticketVO.getOwnerID()) != null ? UserManager.getInstance().getUserAccount(ownerID).getDisplayName() : "";
            String message = resourceName + "\n" + catName + "\n" + ownerName;
            Notification notification = new Notification((String)title, message);
            notification.setGroupingKey("helpdesk.notification.resource");
            notification.setTargetUrl("ticketlist/ticket/" + ticketVO.getBundleID());
            String prefix = Base64.getEncoder().withoutPadding().encodeToString("ticketlist".getBytes(StandardCharsets.UTF_8)).toLowerCase();
            String suffix = String.valueOf(ticketVO.getBundleID());
            char[] guid = new char[25];
            Arrays.fill(guid, '0');
            System.arraycopy(prefix.toCharArray(), 0, guid, 0, prefix.length());
            System.arraycopy(suffix.toCharArray(), 0, guid, 25 - suffix.length(), suffix.length());
            notification.setId(GUID.valueOf((String)new String(guid)));
            NotificationManager.getInstance().sendNotification(user.getID(), notification);
        }
    }

    @Nullable
    public static String getEmailFrom(@Nullable UserAccount account) {
        String[] allEmails;
        if (account != null && (allEmails = UserModelConverter.getEmailAddresses(account)).length > 0) {
            return allEmails[0];
        }
        return null;
    }

    public static int getMailType(TicketDataConnector.MailNotification mailNotification, int actionID, boolean actionIsOpenToClosedTransition, boolean actionResultsInClosedOrDeletedTicket) {
        if (mailNotification == TicketDataConnector.MailNotification.NEVER) {
            return 0;
        }
        if (actionResultsInClosedOrDeletedTicket && !actionIsOpenToClosedTransition) {
            return 0;
        }
        switch (actionID) {
            case -14: {
                return 0;
            }
            case 5: {
                if (mailNotification == TicketDataConnector.MailNotification.ALWAYS) {
                    boolean mailAutorisierungUser = (Boolean)MAIL_AUTORISIERUNG_USER.get();
                    return mailAutorisierungUser ? 2 : 14;
                }
                if (mailNotification == TicketDataConnector.MailNotification.NO_MAILS_TO_ENDUSER) {
                    boolean mailAutorisierungUser = (Boolean)MAIL_AUTORISIERUNG_USER.get();
                    return !mailAutorisierungUser ? 2 : 14;
                }
                return 2;
            }
            case -12: 
            case -11: 
            case -9: 
            case -2: {
                return 10;
            }
            case 6: {
                return 1;
            }
            case 8: {
                return 3;
            }
            case 4: {
                return 6;
            }
        }
        if (actionIsOpenToClosedTransition) {
            if (mailNotification == TicketDataConnector.MailNotification.ALWAYS) {
                boolean mailBeendenUser = (Boolean)MAIL_BEENDEN_USER.get();
                return mailBeendenUser ? 4 : 16;
            }
            if (mailNotification == TicketDataConnector.MailNotification.NO_MAILS_TO_ENDUSER) {
                boolean mailBeendenUser = (Boolean)MAIL_BEENDEN_USER.get();
                return !mailBeendenUser ? 4 : 16;
            }
            return 4;
        }
        return 0;
    }
}

