/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic.userimport;

import com.inet.helpdesk.config.FieldMappingEntry;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import srv.automatic.ImportUtilities;
import srv.automatic.userimport.ImportUserDataStates;

public class UserImportData {
    private int id;
    private UserAccount userAccount;
    private boolean supporter;
    private boolean active;
    private String importKey;
    private int loginCount;
    private ArrayList<UserClassManager.SupervisorMemberShip> supervisedGroups = new ArrayList();
    private HashMap<FieldMappingEntry, String> data = new HashMap();
    private ImportUserDataStates stateFlag;
    private byte[] imageData = null;

    public UserImportData(UserAccount userAccount, Object importKey, int loginCount) {
        this.id = HDUsersAndGroups.getUserID(userAccount);
        this.active = userAccount.isActive();
        if (this.active) {
            this.setState(ImportUserDataStates.VALID);
        } else {
            this.setState(ImportUserDataStates.INACTIVE);
        }
        this.supporter = HDUsersAndGroups.isDispatcher(userAccount) || HDUsersAndGroups.isResourceMember(userAccount);
        this.importKey = importKey != null ? importKey.toString() : "";
        this.loginCount = loginCount;
        this.userAccount = userAccount;
    }

    public UserImportData(String importKey) {
        this.loginCount = 0;
        this.supporter = false;
        this.active = false;
        this.id = -1;
        this.setState(ImportUserDataStates.UNKNOWN);
        this.importKey = importKey;
    }

    public void addData(FieldMappingEntry fm, String value) throws Exception {
        this.data.put(fm, ImportUtilities.validateValues(fm, value));
    }

    public String getData(FieldMappingEntry fm) {
        return this.data.get(fm);
    }

    public Set<Map.Entry<FieldMappingEntry, String>> getDataEntrySet() {
        return this.data.entrySet();
    }

    public void addSupervisorDataSet(UserClassManager.SupervisorMemberShip sds) {
        this.supervisedGroups.add(sds);
    }

    public List<UserClassManager.SupervisorMemberShip> getSupervisorMemberShips() {
        return this.supervisedGroups;
    }

    public boolean hasSupervisorData() {
        return this.supervisedGroups.size() > 0;
    }

    public String getImportKey() {
        return this.importKey;
    }

    public UserAccount getAccount() {
        return this.userAccount;
    }

    public void setAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
        this.id = HDUsersAndGroups.getUserID(userAccount);
        this.active = true;
    }

    public boolean isSupporter() {
        return this.supporter;
    }

    public int getId() {
        return this.id;
    }

    public int getLoginCount() {
        return this.loginCount;
    }

    public void setLoginCount(int loginCount) {
        this.loginCount = loginCount;
    }

    public ImportUserDataStates getState() {
        return this.stateFlag;
    }

    public void setState(ImportUserDataStates stateFlag) {
        this.stateFlag = stateFlag;
        if (stateFlag == ImportUserDataStates.ALREADY_TREATED) {
            this.imageData = null;
            this.supervisedGroups = null;
            this.data = null;
        }
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageData) {
        this.imageData = imageData;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.active ? "Active User: " : "Inactive User: ");
        Map.Entry usernameEntry = this.data.entrySet().stream().filter(e -> "Username".equals(((FieldMappingEntry)e.getKey()).getDefininitionColumn())).findFirst().get();
        buf.append((String)usernameEntry.getValue()).append(" ").append(this.id).append(" ").append(this.stateFlag.getDescription());
        return buf.toString();
    }
}

