/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.classloader.I18nMessages;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.logging.Logger;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.ServerInterface;
import srv.automatic.trigger.TriggerHandler;

public class ServerUtilities {
    public static final int DB_UNKNOWN = 0;
    public static final int SQL_SERVER_DB = 2;
    public static final int ORACLE_DB = 3;
    public static final int MYSQL_DB = 4;
    public static TriggerHandler TRIGGERS = new TriggerHandler();
    private static final ConfigValue<Boolean> DRIVER_LOG = new ConfigValue<Boolean>(ConfigKey.LOG_DRIVER){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            DriverManager.setLogStream((Boolean)super.get() != false ? System.out : null);
        }
    };
    public static final ConfigValue<Boolean> CLIENT_ENDUSER_SHOWBEARBEITER = new ConfigValue(HDConfigKeys.CLIENT_ENDUSER_SHOWBEARBEITER);
    public static boolean linuxServer = false;
    public static final String HELPDESK_DB = "HDS";
    public static final String sprache_Standard = "xx";
    public static final ConfigValue<Integer> GUI_PORT = new ConfigValue<Integer>(ConfigKey.LISTENER_PORT){

        protected Integer convert(String strValue) throws IllegalArgumentException {
            try {
                return Integer.valueOf(strValue);
            }
            catch (Exception e) {
                return 8002;
            }
        }
    };
    public static ServerInterface serverInterface;
    public static I18nMessages hdsMessages;
    private static final Map<String, String> urlToConnectionCollation;

    public static String getLangMsg(String msgID, Object ... msgParameter) {
        return hdsMessages.getMsg(msgID, msgParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String testDB(String theUrl, String pwd, String theUser, String driverClassName, String name, boolean logOnErrorLevel) {
        block43: {
            block42: {
                dbCon = null;
                st = null;
                rs = null;
                isOracle = driverClassName.equals("com.inet.ora.OraDriver");
                origTimeout = DriverManager.getLoginTimeout();
                DriverManager.setLoginTimeout(10);
                dbCon = DriverManager.getConnection(theUrl, theUser, pwd);
                if (!"HDS".equals(name)) ** GOTO lbl38
                st = dbCon.createStatement();
                rs = st.executeQuery("SELECT * FROM tblOptionen");
                hadNext = rs.next();
                release = hadNext != false ? rs.getInt("Release") : -1;
                if (release == (shouldBeRelease = 267)) break block42;
                var14_23 = ServerUtilities.hdsMessages.getMsg("FalscheDB", new Object[0]);
                DriverManager.setLoginTimeout(origTimeout);
                try {
                    rs.close();
                }
                catch (Throwable var15_27) {
                    // empty catch block
                }
                try {
                    st.close();
                }
                catch (Throwable var15_28) {
                    // empty catch block
                }
                try {
                    dbCon.close();
                }
                catch (Throwable var15_29) {
                    // empty catch block
                }
                return var14_23;
            }
            break block43;
lbl38:
            // 1 sources

            dbMeta = dbCon.getMetaData();
            HDLogger.info(dbMeta.getDatabaseProductName() + " " + dbMeta.getDriverName());
            break block43;
            {
                catch (Throwable var16_30) {
                    throw var16_30;
                }
            }
            finally {
                DriverManager.setLoginTimeout(origTimeout);
            }
        }
        dbMeta = null;
        try {
            rs.close();
        }
        catch (Throwable release) {
            // empty catch block
        }
        try {
            st.close();
        }
        catch (Throwable release) {
            // empty catch block
        }
        try {
            dbCon.close();
        }
        catch (Throwable release) {
            // empty catch block
        }
        return dbMeta;
        catch (Throwable er) {
            try {
                msg = er.getMessage();
                if (er.getCause() instanceof UnknownHostException) {
                    msg = ServerUtilities.hdsMessages.getMsg("UnknownHost", new Object[0]);
                } else if (er instanceof SQLInvalidAuthorizationSpecException || er.getMessage() != null && er.getMessage().contains("Access denied for user")) {
                    msg = ServerUtilities.hdsMessages.getMsg(isOracle != false ? "InvalidAuthorizationDb" : "InvalidAuthorization", new Object[0]);
                } else if (msg != null && msg.contains("TLS10")) {
                    msg = (String)msg + "\n" + ServerUtilities.hdsMessages.getMsg("DatabaseTLSUpdateNeeded", new Object[0]);
                }
                if (msg == null || msg.length() == 0) {
                    msg = er.toString();
                }
                exception = new HelpDeskServerException(er, (ErrorCode)HelpDeskErrorCodes.SQL_CONNECTION_TEST_ERROR);
                if (logOnErrorLevel) {
                    HDLogger.error(exception);
                } else {
                    HDLogger.debug(exception);
                }
                var13_22 = msg;
                return var13_22;
            }
            catch (Throwable var17_31) {
                throw var17_31;
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable var14_24) {}
                try {
                    st.close();
                }
                catch (Throwable var14_25) {}
                try {
                    dbCon.close();
                }
                catch (Throwable var14_26) {}
            }
        }
    }

    public static Properties generateConnectionProperties(String theUrl, String user, String pw, String driverClassName) {
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", pw);
        if ("com.mysql.cj.jdbc.Driver".equals(driverClassName)) {
            info.put("sessionVariables", "sql_mode = 'NO_BACKSLASH_ESCAPES'");
            String collation = urlToConnectionCollation.get(theUrl);
            if (collation == null) {
                try (Connection conn = DriverManager.getConnection(theUrl, info);){
                    collation = ServerUtilities.getMySQLCollation(conn);
                    info.put("connectionCollation", collation);
                    urlToConnectionCollation.put(theUrl, collation);
                }
                catch (Throwable th) {
                    HDLogger.debug(th);
                }
            } else {
                info.put("connectionCollation", collation);
            }
        }
        return info;
    }

    public static String getMySQLCollation(@Nonnull Connection conn) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SHOW VARIABLES WHERE Variable_name = 'collation_database'");
        rs.next();
        String collation = rs.getString("Value");
        rs.close();
        return collation;
    }

    public static void systemOut(String sqlQueryID, Throwable e, String msg) {
        ServerUtilities.systemOut(sqlQueryID, e, msg, HDLogger.LOG);
    }

    public static void systemOut(String problem, Throwable e, String msg, Logger logger) {
        logger.info((Object)(problem + "\t" + Runtime.getRuntime().totalMemory() + "\t" + Runtime.getRuntime().freeMemory()));
        if (msg != null) {
            StringBuffer msgBuffer = new StringBuffer();
            msgBuffer.append("\t");
            msgBuffer.append(msg);
            msgBuffer.append("\n");
            logger.info((Object)msgBuffer.toString());
        }
        if (e != null) {
            logger.error(e);
            while (e != null) {
                if (e instanceof SQLException) {
                    logger.warn((Object)("\tSQL State:" + ((SQLException)e).getSQLState() + "\tError Code:" + ((SQLException)e).getErrorCode()));
                    e = ((SQLException)e).getNextException();
                    continue;
                }
                e = null;
            }
        }
    }

    static {
        hdsMessages = new I18nMessages("com.inet.helpdesk.i18n.HDSMsg", ServerUtilities.class);
        LoaderUtils.getUpdateableClassLoader();
        urlToConnectionCollation = Collections.synchronizedMap(new HashMap());
    }
}

