/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.data.HelpDeskTicketIdResponseData;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketActionApplyHandler;
import com.inet.helpdesk.webapi.ticket.HelpDeskTicketActionListHandler;
import com.inet.helpdesk.webapi.ticket.step.HelpDeskTicketStepsHandler;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import com.inet.http.ClientMessageException;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Tag(name="Tickets", description="Operations for managing HelpDesk tickets")
@InternalApi
public class HelpDeskTicketIdHandler
extends RequestHandler.WithCurrentPathToken<Void, TicketVO, Integer> {
    public HelpDeskTicketIdHandler() {
        super(new String[]{"ticket"});
        this.registerRequestHandler((RequestHandlerBase)new HelpDeskTicketActionApplyHandler());
        this.registerRequestHandler((RequestHandlerBase)new HelpDeskTicketStepsHandler());
        this.registerRequestHandler((RequestHandlerBase)new HelpDeskTicketActionListHandler());
    }

    public Integer typeFor(String token) {
        boolean requiresEncodedToken = HelpDeskWebAPIHelper.requestRequiresEncodedTicketId();
        int ticketID = Tickets.decodeTicketID(token, requiresEncodedToken);
        if (ticketID == -1) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicketId", new Object[]{token}));
        }
        return ticketID;
    }

    public String getHelpPageKey() {
        return "webapi.ticket.id";
    }

    @Operation(summary="Get ticket details by ID", description="Retrieves detailed information about a specific ticket including requested fields and attributes", responses={@ApiResponse(responseCode="200", description="Ticket details retrieved successfully", content={@Content(schema=@Schema(implementation=HelpDeskTicketIdResponseData.class), examples={@ExampleObject(name="Welcome Ticket", value="{\"ticketId\":1,\"ticketIdReference\":\"TicketID 1K2dJ\",\"fields\":{\"resourceid\":\"agwefe14jvowtechdc8y8t5hq\",\"subject\":\"Herzlich willkommen im i-net HelpDesk\",\"additionalticketaccess\":{\"readAccess\":[],\"writeAccess\":[]},\"itilid\":0,\"classificationid\":0,\"priorityid\":60},\"attributes\":{\"ticketguid\":\"9pkarmczxoxlj8a13ebro5iq1\",\"attachments\":true,\"dispatchingreastepid\":3,\"lastchangedbyid\":\"dibcgfn3yhzioc4na1y2jzoey\",\"autoescalated\":false,\"itillinkcount\":0,\"sumtime\":0,\"statusid\":103,\"process.isoriginal\":true,\"inquirydate\":1737991110000,\"lasteditorid\":\"dibcgfn3yhzioc4na1y2jzoey\",\"lastchanged\":1738671109000,\"initialreastepid\":1}}")})}), @ApiResponse(responseCode="400", description="Invalid ticket ID format"), @ApiResponse(responseCode="401", description="User not authorized to view ticket"), @ApiResponse(responseCode="404", description="Ticket not found")})
    public TicketVO handle(HttpServletRequest request, HttpServletResponse response, @Nullable Void inputObject, @Nullable Integer ticketId, boolean previewModeEnabled) throws IOException {
        ticketId = HelpDeskWebAPIHelper.checkTicketReadAccessOrThrow(ticketId, response);
        TicketVO ticket = TicketManager.getReader().getTicket(ticketId);
        if (ticket == null) {
            throw new ClientMessageException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.notATicket", new Object[0]));
        }
        List<String> requestedFields = HelpDeskWebAPIHelper.getRequestedFields(request, fields -> {
            fields.addAll(ticket.getIncludedAttributes().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
            fields.addAll(ticket.getIncludedFields().parallelStream().map(a -> a.getKey()).collect(Collectors.toList()));
        });
        ResponseWriter.json((HttpServletResponse)response, (Object)HelpDeskTicketIdResponseData.from(ticket, requestedFields));
        return ticket;
    }

    public boolean shouldSendJsonResponse() {
        return false;
    }
}

