/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.search.SearchTagBundleSlave;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketListState;
import com.inet.helpdesk.core.ticketview.TicketListUpdateListener;
import com.inet.helpdesk.core.ticketview.TicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.helpdesk.core.ticketview.TicketViewVisibility;
import com.inet.helpdesk.core.ticketview.ViewUpdateListener;
import com.inet.helpdesk.ticketview.BaseTicketListChangeMonitor;
import com.inet.helpdesk.ticketview.CustomTicketViewFactory;
import com.inet.helpdesk.ticketview.TicketListChangeMonitor;
import com.inet.helpdesk.ticketview.TicketViewDefGlobalCache;
import com.inet.helpdesk.ticketview.TicketViewTree;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.helpdesk.usersandgroups.ui.UserFieldsWithClientSettingManager;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultListener;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketViewManagerImpl
implements TicketViewManager {
    public static final ConfigValue<Boolean> OPTION_HIDE_REMINDER = new ConfigValue<Boolean>(HDConfigKeys.CLIENT_START_OPTION){

        protected void setValue(String strValue) throws IllegalArgumentException {
            Boolean oldValue = (Boolean)this.get();
            super.setValue(strValue);
            Boolean newValue = (Boolean)this.get();
            if (!Objects.equals(oldValue, newValue) && ServerPluginManager.getInstance().getState() == ServerPluginManager.ServerPluginManagerState.INIT) {
                ((TicketViewManagerImpl)TicketViewManager.getInstance()).notifyAllTreeChanges();
            }
        }

        protected Boolean convert(String strValue) throws IllegalArgumentException {
            Object options = super.convert(strValue);
            return ((Integer)options & 0x20000000) == 0x20000000;
        }
    };
    private static final DynamicExtension<SubViewGroupingDefinition> GROUPING_DEFINITIONS = new DynamicExtension(SubViewGroupingDefinition.class);
    private Map<GUID, TicketViewTree> clients = new HashMap<GUID, TicketViewTree>();
    private boolean isInit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.isInit) {
            return;
        }
        Map<GUID, TicketViewTree> map = this.clients;
        synchronized (map) {
            if (this.isInit) {
                return;
            }
            this.isInit = true;
        }
        ForkJoinPool.commonPool().execute(() -> {
            IndexSearchEngine<Integer> eng = TicketManager.getReader().getSearchEngine();
            SearchCommand command = new SearchCommand("bundleslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagBundleSlave.TRUE);
            eng.addSearchResultListener((SearchResultListener)new SearchResultListener<Integer>(command){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void onPossibleChange() {
                    Map<GUID, TicketViewTree> map = TicketViewManagerImpl.this.clients;
                    synchronized (map) {
                        for (TicketViewTree tree : TicketViewManagerImpl.this.clients.values()) {
                            tree.onPossibleChange();
                        }
                    }
                }
            });
        });
    }

    @Override
    @Nonnull
    public Collection<TicketViewState> registerTicketViews(@Nonnull String clientID) {
        this.init();
        return this.findViewsForCurrentUser(clientID).getStates(clientID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTicketViews(@Nonnull String clientID) {
        Map<GUID, TicketViewTree> map = this.clients;
        synchronized (map) {
            Iterator<TicketViewTree> it = this.clients.values().iterator();
            while (it.hasNext()) {
                TicketViewTree tree = it.next();
                if (!tree.removeClient(clientID)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void addViewUpdateListener(String clientID, ViewUpdateListener viewUpdateListener) {
        this.findViewsForCurrentUser(clientID).putViewUpdateListener(clientID, viewUpdateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TicketViewTree findViewsForCurrentUser(@Nonnull String clientID) throws IllegalStateException {
        TicketViewTree tree;
        UserManager userManager = UserManager.getInstance();
        GUID accountID = userManager.getCurrentUserAccountID();
        if (accountID == null) {
            throw new AccessDeniedException();
        }
        Map<GUID, TicketViewTree> map = this.clients;
        synchronized (map) {
            tree = this.clients.get(accountID);
            if (tree == null) {
                tree = new TicketViewTree(accountID);
                UserAccount userAccount = userManager.getUserAccount(accountID);
                tree.setFactories(this.getViewFactories(tree, userAccount), this.getViewVisibilities(userAccount));
                tree.putViewUpdateListener(clientID, new ViewUpdateListener(){

                    @Override
                    public void viewContentChanged(TicketViewState ticketViewState) {
                    }

                    @Override
                    public void viewStructureChanged(Collection<TicketViewState> ticketViewStates) {
                    }
                });
                this.clients.put(accountID, tree);
            }
        }
        return tree;
    }

    @Override
    public void registerTicketList(@Nonnull String clientID, TicketListUpdateListener updateListener, TicketListState state) {
        this.findViewsForCurrentUser(clientID).registerTicketList(clientID, updateListener, state);
    }

    @Override
    public void unregisterTicketList(String clientID) {
        this.findViewsForCurrentUser(clientID).unregisterTicketList(clientID);
    }

    @Override
    public void setTicketListState(String clientID, TicketListState state) {
        this.findViewsForCurrentUser(clientID).setTicketListState(clientID, state);
    }

    @Override
    public Predicate<Integer> getTicketCondition(@Nonnull String clientID, boolean viewEditor) {
        SearchCommand command;
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        TicketViewTree tree = this.findViewsForCurrentUser(clientID);
        BaseTicketListChangeMonitor changeMonitor = tree.getChangeMonitor(clientID);
        if (viewEditor) {
            command = new SearchCommand(new SearchExpression[0]);
        } else if (changeMonitor instanceof TicketListChangeMonitor) {
            command = ((TicketListChangeMonitor)changeMonitor).getSearchCommand().clone();
            Iterator it = command.getSearchExpression().iterator();
            while (it.hasNext()) {
                SearchExpression searchExpression = (SearchExpression)it.next();
                if (searchExpression.getType() != SearchExpression.Type.Phrase) continue;
                it.remove();
            }
        } else {
            return t -> false;
        }
        command.setID(new SearchID((Object)("suggestions" + clientID)));
        if (!SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ})) {
            GUID accountID = userAccount.getID();
            HashSet<GUID> resources = ResourceSubViewGrouping.getResourceIDs(accountID);
            if (resources.size() == 0) {
                command.getSearchExpression().add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
            } else {
                command.getSearchExpression().add((SearchExpression)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resources));
            }
        }
        if (command.getSearchExpression().size() == 0) {
            return t -> true;
        }
        return new Predicate<Integer>(){
            private Set<Integer> ticketIDs;

            @Override
            public boolean test(Integer id) {
                if (this.ticketIDs == null) {
                    this.ticketIDs = TicketManager.getReader().getSearchEngine().simpleSearch(command);
                }
                return this.ticketIDs.contains(id);
            }
        };
    }

    private List<TicketViewFactory> getViewFactories(TicketViewTree tree, @Nonnull UserAccount userAccount) {
        ArrayList<TicketViewFactory> result = new ArrayList<TicketViewFactory>();
        GUID accountID = tree.getAccountID();
        UserGroupManager groupManager = UserGroupManager.getInstance();
        Set groups = groupManager.getGroupsForUser(accountID);
        TicketViewDefGlobalCache.addViewsForGroups(groups, result, tree);
        TicketViewManagerImpl.addViewDefinitions(TicketViewManagerImpl.loadViewsOfUser(userAccount), result, tree);
        result.addAll(ServerPluginManager.getInstance().get(TicketViewFactory.class));
        return result;
    }

    private static ArrayList<CustomTicketViewDefinition> loadViewsOfUser(UserAccount userAccount) {
        String viewStr = (String)userAccount.getValue(TICKET_VIEW_USERFIELD);
        if (!StringFunctions.isEmpty((String)viewStr)) {
            try {
                return (ArrayList)new Json().fromJson(viewStr, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{CustomTicketViewDefinition.class}), new HashMap());
            }
            catch (JsonException ex) {
                HDLogger.error((Object)ex);
            }
        }
        return new ArrayList<CustomTicketViewDefinition>();
    }

    private static void saveToUser(GUID accountID, ArrayList<CustomTicketViewDefinition> data) {
        MutableUserData userData = new MutableUserData();
        userData.put(TICKET_VIEW_USERFIELD, (Object)new Json().toJson(data));
        UserManager.getInstance().updateUserData(accountID, userData);
    }

    private static void addViewDefinitions(List<CustomTicketViewDefinition> views, @Nonnull List<TicketViewFactory> result, TicketViewTree tree) {
        try (UserAccountScope scope = UserAccountScope.create((GUID)tree.getAccountID());){
            for (CustomTicketViewDefinition viewDef : views) {
                CustomTicketViewFactory factory = new CustomTicketViewFactory(viewDef, tree);
                String subViewGroupingKey = viewDef.getSubViewGroupingKey();
                if (subViewGroupingKey != null && factory.getSubViewGrouping() == null) continue;
                result.add(factory);
            }
        }
    }

    @Override
    public List<TicketViewDefinition> getViewDefinitions() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        GUID accountID = userAccount.getID();
        boolean showAll = SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TEMPLATE_DEFINITION});
        List standardViews = ServerPluginManager.getInstance().get(TicketViewFactory.class);
        if (!showAll) {
            IndexSearchEngine<Integer> engine = TicketManager.getReader().getSearchEngine();
            Iterator it = standardViews.iterator();
            while (it.hasNext()) {
                TicketViewFactory factory = (TicketViewFactory)it.next();
                if (factory.createSearchCommand(accountID, Locale.getDefault(), engine) != null) continue;
                it.remove();
            }
        }
        ArrayList<TicketViewDefinition> result = new ArrayList<TicketViewDefinition>();
        result.addAll(TicketViewManagerImpl.loadViewsOfUser(userAccount));
        List<CustomTicketViewDefinition> gloableViews = TicketViewDefGlobalCache.getViews();
        if (showAll) {
            result.addAll(gloableViews);
        } else {
            ArrayList<CustomTicketViewDefinition> checkParentLater = new ArrayList<CustomTicketViewDefinition>();
            List<SubViewGroupingDefinition> grouping = this.getSubViewGroupingDefinitions();
            Set userGroups = UserGroupManager.getInstance().getGroupsForUser(userAccount.getID());
            for (CustomTicketViewDefinition view : gloableViews) {
                String groupingKey;
                List<String> groups = view.getUserGroups();
                if (groups != null && !userGroups.stream().anyMatch(g -> groups.contains(g.getID().toString())) || (groupingKey = view.getSubViewGroupingKey()) != null && !grouping.stream().anyMatch(g -> groupingKey.equals(g.getKey()))) continue;
                String parentID = view.getParentID();
                if (parentID != null && !standardViews.stream().anyMatch(f -> f.getID().equals(parentID))) {
                    checkParentLater.add(view);
                    continue;
                }
                result.add(view);
            }
            for (CustomTicketViewDefinition view : checkParentLater) {
                String parentID = view.getParentID();
                int idx = parentID.indexOf(46);
                if (idx <= 0) continue;
                String pID = parentID.substring(0, idx);
                if (!result.stream().anyMatch(f -> f.getID().equals(pID))) continue;
                result.add(view);
            }
        }
        result.addAll(standardViews);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public CustomTicketViewDefinition createCustomView(@Nonnull String id, @Nullable String parentId, @Nullable String displayName, @Nullable String description, String phrase, String subViewGroupingKey, boolean tokenizeGroupingValues, boolean hideSubnodeTickets, @Nullable List<String> userGroups, byte[] icondata, GUID originalCreator) {
        CustomTicketViewFactory customFactory;
        TicketViewTree tree;
        UserManager userManager = UserManager.getInstance();
        GUID accountID = userManager.getCurrentUserAccountID();
        if (accountID == null) {
            throw new AccessDeniedException();
        }
        HashSet<String> knownIds = new HashSet<String>();
        knownIds.add(id);
        Map<GUID, TicketViewTree> map = this.clients;
        synchronized (map) {
            tree = this.clients.get(accountID);
        }
        if (parentId != null) {
            TicketViewSearchCommandFactory parentFactory = tree.getTicketViewSearchFactory(parentId);
            if (parentFactory instanceof CustomTicketViewFactory) {
                knownIds.add(parentId);
                customFactory = (CustomTicketViewFactory)parentFactory;
                CustomTicketViewDefinition customDef = customFactory.getCustomView();
                phrase = StringFunctions.isEmpty((String)phrase) ? customDef.getSearchPhrase() : customDef.getSearchPhrase() + " " + (String)phrase;
                parentId = customDef.getParentID();
                if (parentId != null && knownIds.contains(parentId)) {
                    parentId = null;
                }
            } else {
                CustomTicketViewFactory customFactory2;
                CustomTicketViewDefinition customDef;
                String pId = parentId;
                do {
                    int idx;
                    if ((idx = pId.indexOf(".")) > 0) {
                        knownIds.add(pId);
                        pId = pId.substring(0, idx);
                    }
                    if (knownIds.contains(pId)) {
                        CustomTicketViewDefinition customDef2 = new CustomTicketViewDefinition(id, parentId, displayName, description, (String)phrase, subViewGroupingKey, tokenizeGroupingValues, hideSubnodeTickets, userGroups, icondata, originalCreator);
                        throw new ClientMessageException(Tickets.MSG.getMsg("view.error.circle", new Object[]{customDef2.getDisplayName()}));
                    }
                    knownIds.add(pId);
                } while (!((parentFactory = tree.getTicketViewSearchFactory(pId)) instanceof CustomTicketViewFactory ? (pId = (customDef = (customFactory2 = (CustomTicketViewFactory)parentFactory).getCustomView()).getParentID()) == null : pId.indexOf(".") < 0));
            }
        }
        CustomTicketViewDefinition customDef = new CustomTicketViewDefinition(id, parentId, displayName, description, (String)phrase, subViewGroupingKey, tokenizeGroupingValues, hideSubnodeTickets, userGroups, icondata, originalCreator);
        customFactory = new CustomTicketViewFactory(customDef, tree);
        customFactory.createSearchCommand(accountID, Locale.getDefault(), TicketManager.getReader().getSearchEngine());
        return customDef;
    }

    @Override
    public void putView(@Nonnull CustomTicketViewDefinition view) {
        String id = view.getID();
        if (view.getUserGroups() == null) {
            TicketViewDefGlobalCache.removeView(id);
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount == null) {
                return;
            }
            GUID accountID = userAccount.getID();
            UserAccount creatorAccount = null;
            if (view.getOriginalCreator() != null) {
                creatorAccount = UserManager.getInstance().getUserAccount(view.getOriginalCreator());
            }
            if (view.getOriginalCreator() != null && !view.getOriginalCreator().equals((Object)accountID) && creatorAccount != null) {
                ArrayList<CustomTicketViewDefinition> list = TicketViewManagerImpl.loadViewsOfUser(creatorAccount);
                TicketViewDefGlobalCache.removeFromList(list, id, () -> {}, () -> {});
                list.add(view);
                TicketViewManagerImpl.saveToUser(creatorAccount.getID(), list);
                this.notifyTreeChanges(creatorAccount.getID());
            } else {
                ArrayList<CustomTicketViewDefinition> list = TicketViewManagerImpl.loadViewsOfUser(userAccount);
                TicketViewDefGlobalCache.removeFromList(list, id, () -> {}, () -> {});
                list.add(view);
                TicketViewManagerImpl.saveToUser(accountID, list);
                this.notifyTreeChanges(accountID);
            }
        } else {
            this.removeViewLocal(id);
            TicketViewDefGlobalCache.putView(view);
            this.notifyAllTreeChanges();
        }
    }

    @Override
    public boolean removeView(String id) {
        if (TicketViewDefGlobalCache.removeView(id)) {
            this.notifyAllTreeChanges();
            return true;
        }
        return this.removeViewLocal(id);
    }

    private boolean removeViewLocal(String id) {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        ArrayList<CustomTicketViewDefinition> list = TicketViewManagerImpl.loadViewsOfUser(userAccount);
        if (TicketViewDefGlobalCache.removeFromList(list, id, () -> {}, () -> {})) {
            if (userAccount == null) {
                return false;
            }
            GUID accountID = userAccount.getID();
            TicketViewManagerImpl.saveToUser(accountID, list);
            this.notifyTreeChanges(accountID);
            return true;
        }
        return false;
    }

    @Override
    public void setViewVisibilities(List<TicketViewVisibility> list) {
        MutableUserData userData = new MutableUserData();
        userData.put(TICKET_VIEW_VISIBILITY, (Object)new Json().toJson(list));
        UserManager manager = UserManager.getInstance();
        GUID accountID = manager.getCurrentUserAccountID();
        manager.updateUserData(accountID, userData);
        this.notifyTreeChanges(accountID);
    }

    @Override
    public List<TicketViewVisibility> getViewVisibilities() {
        return this.getViewVisibilities(UserManager.getInstance().getCurrentUserAccount());
    }

    private List<TicketViewVisibility> getViewVisibilities(@Nonnull UserAccount userAccount) {
        List fromJson;
        String viewStrDefault;
        List fromJson2;
        String viewStr = (String)userAccount.getValue(TICKET_VIEW_VISIBILITY);
        List vis = !StringFunctions.isEmpty((String)viewStr) ? (fromJson2 = (List)new Json().fromJson(viewStr, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{TicketViewVisibility.class}))) : (!StringFunctions.isEmpty((String)(viewStrDefault = UserFieldsWithClientSettingManager.getInstance().getDefaultValueForUserField((UserField<String>)TICKET_VIEW_VISIBILITY))) ? (fromJson = (List)new Json().fromJson(viewStrDefault, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{TicketViewVisibility.class}))) : TicketViewDefGlobalCache.getViewVisibilities());
        return vis;
    }

    @Override
    @Nonnull
    public List<SubViewGroupingDefinition> getSubViewGroupingDefinitions() {
        ArrayList<SubViewGroupingDefinition> result = new ArrayList<SubViewGroupingDefinition>(GROUPING_DEFINITIONS.get());
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        List<String> visibleFields = Tickets.getFieldIdsVisibleForUser();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            boolean readRight;
            SubViewGroupingDefinition view = (SubViewGroupingDefinition)it.next();
            if (!visibleFields.contains(view.getRelatedFieldKey())) {
                it.remove();
                continue;
            }
            if (!(view instanceof ResourceSubViewGrouping) || (readRight = SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ})) || !ResourceSubViewGrouping.getResourceIDs(userAccount.getID()).isEmpty()) continue;
            it.remove();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAllOnPossibleChange(SubViewGroupingDefinition grouping) {
        ArrayList<TicketViewTree> list;
        Map<GUID, TicketViewTree> map = this.clients;
        synchronized (map) {
            list = new ArrayList<TicketViewTree>(this.clients.values());
        }
        for (TicketViewTree tree : list) {
            tree.onPossibleChange(grouping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAllTreeChanges() {
        ArrayList<TicketViewTree> list;
        Map<GUID, TicketViewTree> map = this.clients;
        synchronized (map) {
            list = new ArrayList<TicketViewTree>(this.clients.values());
        }
        for (TicketViewTree tree : list) {
            this.notifyTreeChanges(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyTreeChanges(GUID accountID) {
        TicketViewTree tree;
        Map<GUID, TicketViewTree> map = this.clients;
        synchronized (map) {
            tree = this.clients.get(accountID);
        }
        if (tree != null) {
            this.notifyTreeChanges(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTreeChanges(TicketViewTree tree) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(tree.getAccountID());
        if (userAccount == null) {
            Map<GUID, TicketViewTree> map = this.clients;
            synchronized (map) {
                this.clients.remove(tree.getAccountID());
                tree.setFactories(Collections.emptyList(), Collections.emptyList());
                return;
            }
        }
        List<TicketViewFactory> factories = this.getViewFactories(tree, userAccount);
        tree.setFactories(factories, this.getViewVisibilities(userAccount));
    }

    @Override
    public void convertToBunIdsIfNeeded(@Nullable IndexSearchEngine<SlaveInfo> slaveInfoEngine, @Nonnull Set<Integer> aufIDs, GUID accountID) {
        Set result;
        if (slaveInfoEngine != null && (result = slaveInfoEngine.simpleSearch(new SearchCommand("aufid", SearchCondition.SearchTermOperator.IN, aufIDs))).size() > 0) {
            boolean all = SystemPermissionChecker.hasAnyPermission((GUID)accountID, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ, HdPermissions.DISPATCHER});
            Set resources = all ? Collections.emptySet() : ResourceSubViewGrouping.getResourceIDs(accountID);
            for (SlaveInfo info : result) {
                if (!all && !Objects.equals(info.getOwnerID(), accountID) && !resources.contains(info.getResID())) continue;
                aufIDs.remove(info.getAufID());
                aufIDs.add(info.getBunID());
            }
        }
    }
}

