/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.ticketview.TicketViewManagerImpl;
import com.inet.helpdesk.ticketview.subview.MyResourceSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;

public class TicketViewGroupEventListener
implements UserGroupEventListener {
    public void groupCreated(@Nonnull UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, false);
    }

    public void groupRenamed(@Nonnull String previousGroupName, @Nonnull UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    public void groupParentChanged(@Nonnull UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    public void groupDataUpdated(@Nonnull UserGroupInfo groupInfo) {
        this.notifyResourcesViewChanged(false);
    }

    public void groupMembersUpdated(@Nonnull UserGroupInfo groupInfo, @Nonnull Map<GUID, Set<MembershipType>> addedMemberships, @Nonnull Map<GUID, Set<MembershipType>> removedMemberships) {
        this.notifyResourcesViewChanged(true);
    }

    public void groupDeleted(@Nonnull UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    public void groupDeactivated(@Nonnull UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    private void notifyIfResourceChanged(UserGroupInfo groupInfo, boolean metaDataChanged) {
        if (groupInfo.getType() != HDUsersAndGroups.RESOURCE) {
            return;
        }
        this.notifyResourcesViewChanged(metaDataChanged);
    }

    private void notifyResourcesViewChanged(boolean metaDataChanged) {
        if (metaDataChanged) {
            ResourceSubViewGrouping.INSTANCE.incMetaDataVersion();
            MyResourceSubViewGrouping.INSTANCE.incMetaDataVersion();
        }
        ForkJoinPool.commonPool().execute(() -> ((TicketViewManagerImpl)TicketViewManager.getInstance()).notifyAllTreeChanges());
    }
}

