/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TextAccess
implements UserDefinedFunction {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLastValidUserVisibleText(int ticketID) {
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        try (Connection con = connectionFactory.getConnection();
             PreparedStatement pst = con.prepareStatement("SELECT tblRealisierung.was, tblRealisierung.ishtml FROM tblRealisierung INNER JOIN tblAktionen ON tblRealisierung.AktID = tblAktionen.AktID WHERE  tblAktionen.UserInVis = 0 AND tblRealisierung.OrgBunID = ? ORDER BY ReaID DESC");){
            pst.setInt(1, ticketID);
            try (ResultSet rs = pst.executeQuery();){
                String text;
                do {
                    boolean ishtml;
                    if (!rs.next()) return "";
                    text = rs.getString("was");
                    boolean bl = ishtml = rs.getInt("ishtml") != 0;
                    if (!ishtml || text == null) continue;
                    text = HtmlConverter.html2text((String)text);
                } while (StringFunctions.isEmpty((String)text));
                String string = text;
                return string;
            }
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
        return "";
    }
}

