/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.userfilter;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.data.userfilter.UserFilter;
import com.inet.helpdesk.shared.search.rpc.UserListFilterCondition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.HashSet;

public class UserGroupFilter
implements UserFilter {
    private UserListFilterCondition.FilterConditionOperator operation;
    private HashSet<Integer> groupIDs = new HashSet();

    public UserGroupFilter(UserListFilterCondition.FilterConditionOperator operation, String filterString) {
        this.operation = operation;
        try {
            if (filterString.indexOf(44) == -1) {
                this.groupIDs.add(Integer.valueOf(filterString));
            } else {
                String[] split;
                for (String f : split = filterString.split(",")) {
                    this.groupIDs.add(Integer.valueOf(f));
                }
            }
        }
        catch (NumberFormatException e) {
            HDLogger.debug(e);
        }
    }

    @Override
    public int score(UserAccount userAccount) {
        Integer userGroupObject = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
        if (userGroupObject == null) {
            userGroupObject = -2;
        }
        if (this.groupIDs.contains(userGroupObject)) {
            return this.operation == UserListFilterCondition.FilterConditionOperator.startsWith ? 1 : 0;
        }
        return this.operation == UserListFilterCondition.FilterConditionOperator.startsWith ? 0 : 1;
    }
}

