/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.ticketview.TicketViewTree;
import com.inet.helpdesk.ticketview.standardviews.SharedWithMeTicketViewDefinition;
import com.inet.helpdesk.ticketview.standardviews.SupervisorTicketViewDefinition;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class GlobalSearchViewDefinition
implements TicketViewFactory {
    public static final String KEY = "globalticketsearch";
    public static final GlobalSearchViewDefinition INSTANCE = new GlobalSearchViewDefinition();

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getCategoryKey() {
        return "globalsearch";
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        return HelpDeskServer.class.getResource("images/ticketview/ticketsearch.png");
    }

    @Override
    @Nonnull
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, @Nonnull Locale locale, IndexSearchEngine<Integer> engine) {
        OrSearchExpression topOr = GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(accountID, locale, false);
        if (topOr == null) {
            return new SearchCommand(locale, new SearchExpression[0]);
        }
        return new SearchCommand(locale, new SearchExpression[]{topOr});
    }

    @Nullable
    public static OrSearchExpression getGlobalSearchExpressionForAllVisibleTickets(GUID accountID, Locale locale, boolean forUnreadView) {
        SearchExpression searchExpression = GlobalSearchViewDefinition.getGlobalSearchExpressionWithoutAdditionaSharings(accountID, locale, forUnreadView);
        if (searchExpression == null) {
            return null;
        }
        OrSearchExpression topOr = new OrSearchExpression();
        topOr.add((Object)searchExpression);
        topOr.add((Object)SharedWithMeTicketViewDefinition.getSharedTickets(accountID, forUnreadView));
        return topOr;
    }

    @Nullable
    public static SearchExpression getGlobalSearchExpressionWithoutAdditionaSharings(@Nonnull GUID accountID, @Nonnull Locale locale, boolean forUnreadView) {
        try (UserAccountScope scape = UserAccountScope.create((GUID)accountID);){
            AndSearchExpression searchExpression;
            boolean isDispatcher = SystemPermissionChecker.checkAccess((Permission)HdPermissions.DISPATCHER);
            if (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ)) {
                if (isDispatcher) {
                    if (forUnreadView) {
                        SearchCondition searchCondition = TicketViewTree.UNREAD_SUPPORTER;
                        return searchCondition;
                    }
                    SearchExpression searchExpression2 = null;
                    return searchExpression2;
                }
                OrSearchExpression or = new OrSearchExpression();
                or.add((Object)GlobalSearchViewDefinition.wrapWithAndIf(forUnreadView, (SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.StartsWith, (Object)""), (SearchExpression)TicketViewTree.UNREAD_SUPPORTER));
                SearchCondition ownUnDispatchedTickets = new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString());
                or.add((Object)GlobalSearchViewDefinition.wrapWithAndIf(forUnreadView, (SearchExpression)ownUnDispatchedTickets, (SearchExpression)GlobalSearchViewDefinition.and(new SearchExpression[]{TicketViewTree.UNREAD_ENDUSER, new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, null)})));
                OrSearchExpression orSearchExpression = or;
                return orSearchExpression;
            }
            HashSet<GUID> resources = ResourceSubViewGrouping.getResourceIDs(accountID);
            AndSearchExpression supervisor = SupervisorTicketViewDefinition.createSearchExpression(accountID, locale);
            if (!isDispatcher && resources.size() == 0) {
                AndSearchExpression and = new AndSearchExpression();
                and.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
                CustomTicketViewDefinition.addCondition_forEndUserFromTicketNumber(accountID, and);
                if (supervisor != null) {
                    OrSearchExpression or = new OrSearchExpression();
                    or.add((Object)and);
                    or.add((Object)supervisor);
                    searchExpression = or;
                } else {
                    searchExpression = and;
                }
                searchExpression = GlobalSearchViewDefinition.wrapWithAndIf(forUnreadView, (SearchExpression)searchExpression, (SearchExpression)TicketViewTree.UNREAD_ENDUSER);
            } else {
                OrSearchExpression or = new OrSearchExpression();
                or.add((Object)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)accountID.toString()));
                if (supervisor != null) {
                    or.add((Object)supervisor);
                }
                if (forUnreadView) {
                    AndSearchExpression and = GlobalSearchViewDefinition.and(new SearchExpression[]{or, TicketViewTree.UNREAD_ENDUSER});
                    and.add((SearchExpression)new SubtractSearchExpression(GlobalSearchViewDefinition.supporterTickets(isDispatcher, resources)));
                    OrSearchExpression unread_or = new OrSearchExpression();
                    unread_or.add((Object)and);
                    unread_or.add((Object)GlobalSearchViewDefinition.and(new SearchExpression[]{GlobalSearchViewDefinition.supporterTickets(isDispatcher, resources), TicketViewTree.UNREAD_SUPPORTER}));
                    or = unread_or;
                } else {
                    or.add((Object)GlobalSearchViewDefinition.supporterTickets(isDispatcher, resources));
                }
                searchExpression = or;
            }
            AndSearchExpression andSearchExpression = searchExpression;
            return andSearchExpression;
        }
    }

    private static SearchExpression supporterTickets(boolean isDispatcher, Set<GUID> resources) {
        OrSearchExpression or = new OrSearchExpression();
        if (isDispatcher) {
            or.add((Object)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.Equals, null));
        }
        if (resources.size() > 0) {
            or.add((Object)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resources));
        }
        return GlobalSearchViewDefinition.wrapWithAndIf(!isDispatcher, (SearchExpression)or, (SearchExpression)new SearchCondition("dispatchingreastepid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
    }

    private static SearchExpression wrapWithAndIf(boolean condition, SearchExpression currentExpression, SearchExpression extraExpression) {
        if (!condition) {
            return currentExpression;
        }
        return GlobalSearchViewDefinition.and(currentExpression, extraExpression);
    }

    private static AndSearchExpression and(SearchExpression ... expr) {
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        for (SearchExpression s : expr) {
            andSearchExpression.add(s);
        }
        return andSearchExpression;
    }

    public static SearchExpression getExpressionForUnreadTickets(Set<Integer> allTicketsFromCurrentNode, GUID accountID, Locale locale) {
        return GlobalSearchViewDefinition.and(new SearchExpression[]{new PrefilteredSearchExpression(allTicketsFromCurrentNode), GlobalSearchViewDefinition.getGlobalSearchExpressionForAllVisibleTickets(accountID, locale, true)});
    }
}

