/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.cache.MemorySize;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import java.util.Set;
import javax.annotation.Nonnull;

public class TicketVOSingle
extends TicketVO
implements MemorySize {
    private final int ticketID;
    private final MutableTicketAttributes attributes;
    private final MutableTicketData ticketData;

    private TicketVOSingle(int ticketID, @Nonnull MutableTicketAttributes attributes, @Nonnull MutableTicketData ticketData) {
        this.ticketID = ticketID;
        this.attributes = attributes.copy();
        this.ticketData = ticketData.copy();
    }

    public static TicketVOSingle create(int ticketID, @Nonnull MutableTicketAttributes attributes, @Nonnull MutableTicketData ticketData) {
        return new TicketVOSingle(ticketID, attributes, ticketData);
    }

    @Override
    public <VALUE> boolean hasAttributeKey(TicketAttribute<VALUE> attribute) {
        return this.attributes.containsAttribute(attribute);
    }

    @Override
    public <VALUE> VALUE getAttribute(TicketAttribute<VALUE> attribute) {
        VALUE value = this.attributes.get(attribute);
        return (VALUE)(value == null ? null : attribute.copyValue(value));
    }

    @Override
    public Set<TicketAttribute<Object>> getIncludedAttributes() {
        return this.attributes.getIncludedAttributes();
    }

    @Override
    public <VALUE> boolean hasFieldKey(TicketField<VALUE> field) {
        return this.ticketData.containsKey(field);
    }

    @Override
    public <VALUE> VALUE getValue(TicketField<VALUE> field) {
        VALUE value = this.ticketData.get(field);
        return (VALUE)(value == null ? null : field.copyValue(value));
    }

    @Override
    public Set<TicketField<Object>> getIncludedFields() {
        return this.ticketData.getIncludedFields();
    }

    @Override
    public int getID() {
        return this.ticketID;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.ticketData == null ? 0 : this.ticketData.hashCode());
        result = 31 * result + this.ticketID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TicketVOSingle other = (TicketVOSingle)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.ticketData == null ? other.ticketData != null : !this.ticketData.equals(other.ticketData)) {
            return false;
        }
        return this.ticketID == other.ticketID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TicketVOSingle: ").append("ID=" + this.ticketID);
        sb.append(" attributes=").append(this.attributes.toString());
        sb.append(" fields=").append(this.ticketData.toString());
        return sb.toString();
    }

    public long getSizeInMemory() {
        return 24L + this.attributes.getSizeInMemory() + this.ticketData.getSizeInMemory();
    }
}

