/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.priority;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.lib.util.StringFunctions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import javax.imageio.ImageIO;

public class PriorityManager
extends GenericFieldsManager<PriorityVO> {
    private static PriorityManager manager = new PriorityManager();

    private PriorityManager() {
        super(PriorityVO.class, "tblPrioritaeten");
    }

    public static PriorityManager getInstance() {
        return manager;
    }

    @Override
    public URL getIcon(int id, int size) {
        return this.getIcon(id, size, true);
    }

    public URL getIcon(int id, int size, boolean generateIfMissing) {
        PriorityVO priority = (PriorityVO)this.get(id);
        if (priority == null) {
            return null;
        }
        URL iconURL = null;
        String imageName = priority.getImageName();
        if (!StringFunctions.isEmpty((String)imageName)) {
            iconURL = this.resolveImageURL(imageName, size);
        }
        if (iconURL == null && generateIfMissing) {
            byte[] generatedPriorityImage = PriorityManager.getGeneratedPriorityImage(priority, size);
            if (generatedPriorityImage != null) {
                try {
                    return new URL("data:image/png;base64," + Base64.getEncoder().encodeToString(generatedPriorityImage));
                }
                catch (MalformedURLException e) {
                    HDLogger.warn(e);
                }
            }
            return null;
        }
        return iconURL;
    }

    public static int getPrioColor(long value, long minPrio, long maxPrio) {
        if (value > maxPrio) {
            value = maxPrio;
        } else if (value < minPrio) {
            value = minPrio;
        }
        long diff = maxPrio - minPrio;
        float ratio = (float)(value - minPrio) / (float)diff;
        return Color.HSBtoRGB(0.33333334f - ratio / 3.0f, 0.45f, 0.98f);
    }

    public static byte[] getGeneratedPriorityImage(PriorityVO priorityVO, int size) {
        List allPriorities = PriorityManager.getInstance().getAll(true);
        long minPrio = allPriorities.stream().filter(p -> !p.isDeleted()).min(Comparator.comparing(FieldVO::getId)).get().getId();
        long maxPrio = allPriorities.stream().filter(p -> !p.isDeleted()).max(Comparator.comparing(FieldVO::getId)).get().getId();
        int color = PriorityManager.getPrioColor(priorityVO.getId(), minPrio, maxPrio);
        try {
            BufferedImage target = new BufferedImage(size, size, 2);
            Graphics2D g = (Graphics2D)target.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            Color prioColor = new Color(color);
            if (!priorityVO.isDeleted()) {
                g.setColor(prioColor);
                g.fillOval(size / 4, size / 4, size / 2, size / 2);
            }
            float[] hsbvals = new float[3];
            Color.RGBtoHSB(prioColor.getRed(), prioColor.getGreen(), prioColor.getBlue(), hsbvals);
            hsbvals[2] = hsbvals[2] * 0.9f;
            g.setColor(new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2])));
            g.drawOval(size / 4, size / 4, size / 2, size / 2);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)target, "PNG", baos);
            byte[] bytes = baos.toByteArray();
            return bytes;
        }
        catch (Throwable t) {
            HDLogger.error(t);
            return null;
        }
    }
}

