/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fields.action;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ActionCreationNotificator;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.GenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionListener;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import java.net.URL;
import java.sql.SQLException;
import java.util.Set;
import java.util.stream.Collectors;

public class ActionManager
extends GenericFieldsManager<ActionVO> {
    private static ActionManager manager = new ActionManager();

    private ActionManager() {
        super(ActionVO.class, "tblAktionen");
    }

    public static ActionManager getInstance() {
        return manager;
    }

    @Override
    public URL getIcon(int id, int size) {
        return null;
    }

    @Override
    public int add(ActionVO vo) throws SQLException {
        return this.add(vo, true);
    }

    public int add(ActionVO vo, boolean grantToSupporters) throws SQLException {
        return this.add0(vo, grantToSupporters);
    }

    private int add0(ActionVO vo, boolean grantToSupporters) throws SQLException {
        int actionID = super.add(vo);
        if (grantToSupporters) {
            Set allowedActions = (Set)UserGroupManager.getInstance().getGroup(HDUsersAndGroups.GROUPID_SUPPORTERS).getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS);
            allowedActions.add(vo.getId());
            MutableUserGroupData data = new MutableUserGroupData();
            data.put((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS, (Object)allowedActions);
            UserGroupManager.getInstance().updateGroupData(HDUsersAndGroups.GROUPID_SUPPORTERS, data);
        }
        ActionCreationNotificator acn = (ActionCreationNotificator)ServerPluginManager.getInstance().getSingleInstance(ActionCreationNotificator.class);
        acn.notifyAboutNewlyCreatedAction(actionID);
        return actionID;
    }

    public Set<Integer> getAllValidIds() {
        return this.getAll(true).stream().map(FieldVO::getId).collect(Collectors.toSet());
    }

    @Override
    public void update(ActionVO vo) throws SQLException {
        boolean willDelete = vo.isDeleted();
        boolean wasDeleted = ((ActionVO)this.get(vo.getId())).isDeleted();
        super.update(vo);
        if (willDelete && !wasDeleted) {
            for (ActionListener l : ServerPluginManager.getInstance().get(ActionListener.class)) {
                try {
                    l.actionDeleted(vo.getId());
                }
                catch (Throwable th) {
                    HDLogger.error(th);
                }
            }
        }
    }
}

