/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationMigrator;
import com.inet.helpdesk.config.AppDataLocation;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.SuppressFBWarnings;

public class LogoFileMigrator
implements ConfigurationMigrator {
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="only set by admin")
    public void migrate(Configuration config) {
        Path path;
        String logoFile = config.get(ConfigKey.IMPRINT_LOGO_URL);
        if (!(logoFile.trim().length() <= 0 || logoFile.startsWith("http:") || logoFile.startsWith("https:") || logoFile.startsWith("file:") || logoFile.startsWith("data:") || (path = Paths.get(logoFile, new String[0])).isAbsolute() || path.toFile().toString().toLowerCase().replace('\\', '/').startsWith("client/images"))) {
            path = AppDataLocation.getClientImageDirectoryPath().resolve(path);
            path = AppDataLocation.getBaseLocationPath().relativize(path);
            logoFile = path.toString();
            config.put(ConfigKey.IMPRINT_LOGO_URL, logoFile);
        }
    }
}

