/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.helpdesk.config.ItilList;
import com.inet.helpdesk.config.ItilListConfigProperty;
import com.inet.helpdesk.config.TicketValueIconConfigProperty;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.ui.TargetValue;
import com.inet.usersandgroups.api.ui.Type;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ITILConfigStructureProvider
extends AbstractStructureProvider {
    public static final String PROP_GROUP_ITIL = "helpdesk.main.itil.main";
    public static final String PROP_GROUP_ITIL_TITLE_LABEL = "helpdesk.itil.title_label";
    private static final String CATEGORY_ITIL = "helpdesk.main.itil";

    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(125, "ticketvalues", this.translate(settings, "ticketvalues", new Object[0])));
    }

    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "ticketvalues": {
                categories.add(new ConfigCategory(137, CATEGORY_ITIL, this.translate(settings, "Itil", new Object[0]), "ticket.values.itil"));
            }
        }
    }

    public URL getCategoryIcon(@Nonnull String categoryKey) {
        try {
            switch (categoryKey) {
                case "helpdesk.main.itil": {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/images/config/itil_48.png");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> configPropertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "helpdesk.main.itil": {
                configPropertyGroups.add(new ConfigPropertyGroup(121, PROP_GROUP_ITIL_TITLE_LABEL));
                configPropertyGroups.add(new ConfigPropertyGroup(123, PROP_GROUP_ITIL));
                break;
            }
        }
    }

    private String translate(ConfigStructureSettings settings, String[] t) {
        if (t != null && t.length > 0) {
            if (t.length == 1) {
                return this.translate(settings, t[0], new Object[0]);
            }
            return this.translate(settings, t[0], Arrays.copyOfRange(t, 1, t.length));
        }
        return null;
    }

    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "helpdesk.main.itil.main": {
                configProperties.add((ConfigProperty)new ItilListConfigProperty(settings, t -> this.translate(settings, t)));
                configProperties.add(new ConfigProperty(5047, "itil.instructions1", "Link", this.translate(settings, "prioLabel", new Object[0]), (Object)this.getTicketFieldSettingsURL(), null, this.translate(settings, "itil.instructions1", new Object[0])));
                break;
            }
            case "helpdesk.itil.title_label": {
                this.addTo(configProperties, "itil.title_label", "Label", settings);
            }
        }
    }

    private String getTicketFieldSettingsURL() {
        Object targetURL = "configmanager/page/configuration.ticket.ticketsettings/dialog/category.fields.tickets";
        String rootURL = SessionStore.getRootURL();
        targetURL = rootURL != null ? rootURL + (String)targetURL : "../" + (String)targetURL;
        return targetURL;
    }

    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        List itils;
        if ("itil.new".equals(categoryKey)) {
            ConfigValidator validator = new ConfigValidator(messages, settings);
            validator.checkNotEmpty("id");
            validator.validateStringLength("name", 1, 50);
            validator.validateStringLength("info", 0, 65535);
        } else if (CATEGORY_ITIL.equals(categoryKey) && (itils = (List)settings.getChangedValue("Itil", List.class)) != null) {
            ItilList list = this.getItilVOs(itils);
            for (ItilVO c : list) {
                Map<Type, Set<GUID>> map = c.getRestrictedTo();
                if (((Integer)Tickets.FIELD_ITIL_ID.getDefaultValue()).intValue() != c.getId() || map != null && map.get(Type.group) != null && map.get(Type.group).contains(UsersAndGroups.GROUPID_ALLUSERS)) continue;
                messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "defaultItilMustBeVisibleForAll", new Object[0]), "Itil"));
            }
        }
    }

    private ItilList getItilVOs(List<Map<String, String>> itils) {
        this.correctItilValuesFromClient(itils);
        ArrayList objMap = new ArrayList();
        itils.forEach(itilMap -> {
            String restrictions = (String)itilMap.remove("restrictions");
            itilMap.remove("IsDefault");
            HashMap<String, 1> mappedMap = new HashMap<String, 1>((Map<String, 1>)itilMap);
            Map<Object, Set<Object>> restrictedTo = restrictions == null ? new HashMap<Type, Set<GUID>>(){
                {
                    this.put(Type.group, new HashSet<GUID>(Collections.singletonList(UsersAndGroups.GROUPID_ALLUSERS)));
                }
            } : TargetValue.getReceivers((String)restrictions);
            mappedMap.put("RestrictedTo", restrictedTo);
            objMap.add(mappedMap);
        });
        return (ItilList)new Json().fromJson(new Json().toJson(objMap), ItilList.class);
    }

    @Nonnull
    public @Nonnull Permission @Nonnull [] getRequiredPermissions() {
        return new Permission[]{HdPermissions.ITIL_DEFINITION, Permission.CONFIGURATION};
    }

    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        if (key.equals("Itil")) {
            ArrayList<Map<String, String>> changedValueRaw = (ArrayList<Map<String, String>>)settings.getChangedValue("Itil", List.class);
            List<String> serializedImageData = null;
            if (changedValueRaw != null) {
                serializedImageData = TicketValueIconConfigProperty.getSerializedImageData((List<Map<String, String>>)changedValueRaw);
            } else {
                changedValueRaw = new ArrayList<Map<String, String>>();
            }
            ItilList list = this.getItilVOs(changedValueRaw);
            ItilManager m = ItilManager.getInstance();
            List all = m.getAll(false);
            ArrayList ids = new ArrayList(all.stream().map(FieldVO::getId).collect(Collectors.toList()));
            for (ItilVO c : list) {
                int originalID = c.getId();
                ItilVO old = (ItilVO)m.get(originalID);
                try {
                    String relativePath;
                    ids.remove((Object)c.getId());
                    if (old == null) {
                        m.add(c);
                    } else {
                        m.update(c);
                    }
                    if ((relativePath = TicketValueIconConfigProperty.storeIcons(serializedImageData, 7, c.getId(), c.getImageName())) == null) continue;
                    m.update(new ItilVO(c.getId(), c.getDisplayValue(), !relativePath.isEmpty() ? relativePath : c.getImageName(), c.isDeleted(), c.isInternal(), c.isMasterType(), c.getProtectedContent(), c.getInfo(), c.getMessageType(), c.getMessageEmail(), c.getRestrictedTo()));
                }
                catch (SQLException e) {
                    HDLogger.error(e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            }
            ids.forEach(i -> {
                try {
                    ItilVO itilVO = (ItilVO)m.get((int)i);
                    m.update(new ItilVO(itilVO.getId(), itilVO.getDisplayValue(), itilVO.getImageName(), true, itilVO.isInternal(), itilVO.isMasterType(), itilVO.getProtectedContent(), itilVO.getInfo(), itilVO.getMessageType(), itilVO.getMessageEmail(), itilVO.getRestrictedTo()));
                }
                catch (SQLException e) {
                    HDLogger.error(e);
                    throw new ClientMessageException(this.translate(settings, "DBError", new Object[0]));
                }
            });
            return ConfigStructure.SaveState.SAVE;
        }
        return super.save(key, value, settings);
    }

    private void correctItilValuesFromClient(List<Map<String, String>> itils) {
        for (Map<String, String> itilMap : itils) {
            itilMap.remove("allids");
            itilMap.remove("isNewlyCreated");
            String internal = itilMap.remove("internal");
            itilMap.put("intern", internal == null ? "false" : internal);
            String messageEmail = itilMap.remove("messageEmail");
            itilMap.put("MsgEmail", messageEmail == null ? "" : messageEmail);
            String messageType = itilMap.remove("messageType");
            itilMap.put("MsgTyp", messageType == null ? "0" : messageType);
            itilMap.put("ItilBezeichnung", itilMap.remove("name"));
            itilMap.put("Info", itilMap.remove("info"));
            int newProtectedContent = "true".equals(itilMap.get("protectedContent")) ? 1 : 0;
            int newAutoclose = "true".equals(itilMap.remove("autoclose")) ? 2 : 0;
            itilMap.put("protectedContent", "" + (newProtectedContent + newAutoclose));
            itilMap.put("masterTyp", itilMap.remove("masterType"));
            itilMap.remove("TicketValueIcons");
            itilMap.put("ItiImage", itilMap.remove("origImage"));
            itilMap.remove("protectedContent.label");
        }
    }
}

