/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITriggerCommand;
import com.inet.dbupdater.model.Node;
import java.sql.SQLException;
import java.util.List;

public class OracleCreateTriggerCommand
implements ITriggerCommand {
    private final DatabaseInfos dbInfo;
    private Node element;

    public OracleCreateTriggerCommand(DatabaseInfos dbInfo) {
        this.dbInfo = dbInfo;
    }

    @Override
    public int execute() throws SQLException {
        return this.dbInfo.getDBConnection().executeUpdate(this.getSqlStatement());
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.createtriggers;
    }

    @Override
    public String getSqlStatement() {
        if (this.element == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE TRIGGER ");
        buffer.append(this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.TRIGGER_PARAM.name.name())));
        buffer.append(" ");
        buffer.append(this.getTiming(this.element.getRecentValue(IDatabaseInfos.TRIGGER_PARAM.timing.name())));
        buffer.append(" ");
        buffer.append(this.element.getRecentValue(IDatabaseInfos.TRIGGER_PARAM.event.name()));
        buffer.append(" ON ");
        buffer.append(this.dbInfo.getQuote(this.element.getRecentValue(IDatabaseInfos.TRIGGER_PARAM.table.name())));
        buffer.append(" FOR EACH ROW ");
        buffer.append(this.element.getContent());
        return buffer.toString();
    }

    private String getTiming(String timing) {
        String t = timing.toLowerCase();
        if (t.startsWith("before")) {
            return "BEFORE";
        }
        if (t.startsWith("after")) {
            return "AFTER";
        }
        return timing;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        this.element = element;
        return null;
    }
}

