/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.databases.commands.DefaultCommandSyntax;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.databases.commands.ITableCommand;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.ISchemaNode;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OracleAlterColumnCommand
implements ITableCommand {
    private DatabaseInfos dbInfo;
    private final Node name;
    private DefaultCommandSyntax syntax;
    private final String prefix;
    private String firstSQL;
    private String tabName;

    public OracleAlterColumnCommand(DatabaseInfos dbInfo, DefaultCommandSyntax syntax, Node tableName) {
        this.name = tableName;
        this.dbInfo = dbInfo;
        this.syntax = syntax;
        this.tabName = ((ISchemaNode)((Object)tableName)).getSourceName(dbInfo);
        this.prefix = "ALTER TABLE " + this.tabName + " ";
    }

    @Override
    public int execute() throws SQLException {
        String sqlStatement = this.getSqlStatement();
        if (this.firstSQL != null) {
            return this.dbInfo.getDBConnection().executeUpdate(sqlStatement);
        }
        return 1;
    }

    @Override
    public String getSqlStatement() {
        return this.firstSQL;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        if (action != ICommandFactory.COMMAND_TYPE.alter) {
            return false;
        }
        NodeFactory.TAG type = element.getName();
        return type == NodeFactory.TAG.column;
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return IDatabaseCommand.TIME.alterstructure;
    }

    private void addCommand(List<IComposedCommand> commands, String command) {
        if (this.firstSQL == null) {
            this.firstSQL = command;
        } else {
            commands.add(this.dbInfo.getCommandFactory().getPresetCommand(command, true, IDatabaseCommand.TIME.alterstructure, false, true));
        }
    }

    private List<IComposedCommand> createCommandsForChangeToLong(Node element) throws SQLException {
        ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
        AttributeMap<String> attributes = element.getAttributeMap();
        ICommandFactory factory = this.dbInfo.getCommandFactory();
        Node diffTarget = element.getDiffTarget();
        Node diffSource = element.getDiffSource();
        String colName = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_name);
        String colNameTemp = colName + "TEMP";
        String targetName = diffTarget.getParameter(IDatabaseInfos.COLUMN_PARAM.column_name.name());
        String sourceName = diffSource.getParameter(IDatabaseInfos.COLUMN_PARAM.column_name.name());
        diffSource.readParameter(IDatabaseInfos.COLUMN_PARAM.column_name.name(), colNameTemp);
        IComposedCommand createColCommand = factory.getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.column, IDatabaseCommand.TIME.addstructure, this.name, colNameTemp);
        createColCommand.addDataset(diffSource, ICommandFactory.COMMAND_TYPE.alter);
        commands.add(createColCommand);
        commands.add(factory.getPresetCommand("UPDATE " + this.tabName + " SET " + colNameTemp + "=" + colName, true, IDatabaseCommand.TIME.dropreferences, false, true));
        commands.add(factory.getPresetCommand("UPDATE " + this.tabName + " SET " + colName + " = NULL", true, IDatabaseCommand.TIME.dropreferences, false, true));
        commands.add(factory.getPresetCommand("UPDATE " + this.tabName + " SET " + targetName + "=" + colNameTemp, true, IDatabaseCommand.TIME.copydata, false, true));
        IComposedCommand dropColumnCommand = factory.getCommand(ICommandFactory.COMMAND_TYPE.alter, NodeFactory.TAG.column, IDatabaseCommand.TIME.dropstructure, this.name, colName);
        dropColumnCommand.addDataset(element.getDiffSource(), ICommandFactory.COMMAND_TYPE.remove);
        commands.add(dropColumnCommand);
        diffSource.readParameter(IDatabaseInfos.COLUMN_PARAM.column_name.name(), sourceName);
        return commands;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        String notNullable;
        String defValue;
        AttributeMap<String> attributes = element.getAttributeMap();
        String name = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_name);
        String type = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.data_type);
        ArrayList<IComposedCommand> commands = new ArrayList<IComposedCommand>();
        if (name == null) {
            throw new IllegalStateException("Cannot alter an unnamed column in table '" + String.valueOf(this.name) + "'");
        }
        if (type != null) {
            try {
                int typeInt = Integer.parseInt(type);
                if (typeInt == -1 && element.getDiffTarget() != null) {
                    commands.addAll(this.createCommandsForChangeToLong(element));
                }
            }
            catch (NumberFormatException typeInt) {
                // empty catch block
            }
        }
        StringBuilder b = new StringBuilder();
        b.append(this.prefix).append("MODIFY ").append(this.dbInfo.getQuote(name));
        String size = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_size);
        String dec_digits = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.decimal_digits);
        String autoinc = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.isautoincrement);
        String typename = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.type_name);
        if (size != null || type != null || dec_digits != null || autoinc != null || typename != null) {
            Node target = element.getDiffTarget();
            if (target == null) {
                target = element;
            }
            b.append(" ").append(this.syntax.getTypeString(target));
        }
        if ((defValue = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_def)) != null) {
            String typeString = element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.data_type.name());
            int typeInt = Integer.parseInt(typeString.toString());
            String defaultValue = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.column_def);
            if ("#removed#".equals(defaultValue)) {
                if (!"true".equalsIgnoreCase(element.getRecentValue(IDatabaseInfos.COLUMN_PARAM.isnotnullable.name()))) {
                    b.append(" DEFAULT NULL");
                } else {
                    b.append(" DEFAULT " + this.dbInfo.getDefaultStringByType(typeInt));
                }
            } else {
                b.append((String)(defValue == null ? "" : " DEFAULT " + this.dbInfo.getQuotedValue(defaultValue, typeInt)));
            }
        }
        if ((notNullable = attributes.get((Object)IDatabaseInfos.COLUMN_PARAM.isnotnullable)) != null) {
            b.append(notNullable == null || notNullable.equals("false") ? " NULL" : " NOT NULL");
        }
        this.addCommand(commands, b.toString());
        return commands.size() > 0 ? commands : null;
    }
}

