/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

public class StringIntHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    Entry currentEntry;
    int readPosition;

    private StringIntHashMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.count = 0;
    }

    public StringIntHashMap() {
        this(256, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isValid() {
        return this.count < 3000;
    }

    public int get(String key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = this.getKeyHashCode(key);
            int index = StringIntHashMap.indexFor(hash, tab.length);
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && this.keyEquals(key, e.key)) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return -1;
    }

    private boolean keyEquals(String key1, String key2) {
        if (key1.length() == key2.length()) {
            return key1.equals(key2);
        }
        return false;
    }

    private int getKeyHashCode(String key) {
        int h = key.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public void put(String key, int value) {
        int hash = this.getKeyHashCode(key);
        int index = StringIntHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && this.keyEquals(key, e.key)) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.table[index] = new Entry(hash, key, value, this.table[index]);
        if (this.count++ >= this.threshold) {
            this.rehash();
        }
    }

    public void putCounter(String key) {
        int hash = this.getKeyHashCode(key);
        int index = StringIntHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && this.keyEquals(key, e.key)) {
                ++e.value;
                return;
            }
            e = e.next;
        }
        this.table[index] = new Entry(hash, key, 1, this.table[index]);
        if (this.count++ >= this.threshold) {
            this.rehash();
        }
    }

    public void clear() {
        if (this.table.length > 4096) {
            int newCapacity = 4096;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.table = new Entry[newCapacity];
        } else {
            Entry[] tab = this.table;
            int index = tab.length;
            while (--index >= 0) {
                tab[index] = null;
            }
        }
        this.count = 0;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = StringIntHashMap.indexFor(e.hash, newCapacity);
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public void moveToStart() {
        this.readPosition = -1;
        this.currentEntry = null;
    }

    public boolean hasMore() {
        if (this.currentEntry != null && this.currentEntry.next != null) {
            this.currentEntry = this.currentEntry.next;
            return true;
        }
        Entry[] tab = this.table;
        ++this.readPosition;
        while (this.readPosition < tab.length) {
            this.currentEntry = tab[this.readPosition];
            if (this.currentEntry != null) {
                return true;
            }
            ++this.readPosition;
        }
        return false;
    }

    public String getCurrentKey() {
        return this.currentEntry.key;
    }

    public int getCurrentValue() {
        return this.currentEntry.value;
    }

    public int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    private static class Entry {
        int hash;
        String key;
        int value;
        Entry next;

        Entry(int hash, String key, int value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }
    }
}

