/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_String;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.user.fields.HDUserField;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class FieldLanguage
extends HDUserField<String>
implements HasSelectOptions {
    public static final String KEY = "language";
    public static final String DEFAULT_VALUE = "xx";
    private static final String SQL_LANGUAGES = "SELECT * FROM tblSprachen";

    public FieldLanguage() {
        super(KEY, DEFAULT_VALUE, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<String> createFieldType() {
        return new FieldTypeSelect_String(KEY, () -> this.getLabel(), this){

            public SearchTag createSearchTag(Supplier<String> displayname, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(FieldLanguage.KEY, SearchDataType.StringMap, false, (SearchTokenizer)TextSearchTokenizer.DEFAULT, 100, () -> HDFieldDisplayNameProvider.getStaticDisplayNameForUserField(FieldLanguage.KEY), true){
                    private Map<String, String> mapData;
                    {
                        this.mapData = null;
                    }

                    @Nonnull
                    public Map<String, String> getMapData() {
                        if (this.mapData == null) {
                            HashMap<String, String> langMap = FieldLanguage.loadLanguagesFromDatabase();
                            this.mapData = langMap;
                        }
                        return this.mapData;
                    }
                });
            }
        };
    }

    private static HashMap<String, String> loadLanguagesFromDatabase() {
        ConnectionFactory connectionFactory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        HashMap<String, String> languages = new HashMap<String, String>();
        try (Connection con = connectionFactory.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(SQL_LANGUAGES);){
            while (rs.next()) {
                String displayName;
                String sprache = rs.getString("Sprache");
                String sprID = rs.getString("SprID");
                if (!sprID.equalsIgnoreCase(displayName = new Locale(sprID).getDisplayName(ClientLocale.getThreadLocale()))) {
                    sprache = displayName;
                }
                languages.put(sprID, sprache);
            }
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
        return languages;
    }

    public void validate(String value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)2);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        HashMap<String, String> languagesFromDatabase = FieldLanguage.loadLanguagesFromDatabase();
        return languagesFromDatabase.entrySet().stream().map(e -> new SelectOption((String)e.getKey(), (String)e.getValue())).toList();
    }
}

