/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets;

import com.inet.authentication.base.LoginManager;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ImagesConnector;
import com.inet.http.PluginServlet;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.utils.MimeTypes;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;

public class ImagesServlet
extends HttpServlet
implements PluginServlet {
    private static final String PATH_DATA = "data/";
    private static final String PATH_DEVICETYPE = "devicetype/";
    private static final String PATH_MIMETYPE = "mimetype/";
    private static final String PATH_MIMETYPE_BY_NAME = "mimetypebyname/";
    private static final String PATH_FIELDTYPE = "fieldtype/";
    private static HashMap<String, byte[]> EMPTY_IMAGES = new HashMap();
    private ImagesConnector imagesConnector;

    @Nonnull
    public String getPathSpec() {
        return "/images";
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
        String path = request.getPathInfo();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        int size = 16;
        String sizeParameter = request.getParameter("size");
        if (!StringFunctions.isEmpty((String)sizeParameter)) {
            try {
                size = Integer.parseInt(sizeParameter);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (path.startsWith(PATH_DATA)) {
            this.serveDataImage(path, request, response, size);
            return;
        }
        if (path.startsWith(PATH_DEVICETYPE) && ServerPluginManager.getInstance().isPluginLoaded("inventory")) {
            this.serveDeviceTypeImage(path, request, response, size);
            return;
        }
        if (path.startsWith(PATH_MIMETYPE)) {
            this.serveMimetypeImage(path, request, response, false, size);
            return;
        }
        if (path.startsWith(PATH_MIMETYPE_BY_NAME)) {
            this.serveMimetypeImage(path, request, response, true, size);
            return;
        }
        if (path.startsWith(PATH_FIELDTYPE)) {
            this.serveFieldTypeImage(path, request, response, size);
            return;
        }
        URL urlToServe = this.getImagesConnector().resolveImageURL(path, size);
        this.serveStaticContent(urlToServe, path, request, response, true);
    }

    private ImagesConnector getImagesConnector() {
        if (this.imagesConnector == null) {
            this.imagesConnector = (ImagesConnector)ServerPluginManager.getInstance().getSingleInstance(ImagesConnector.class);
        }
        return this.imagesConnector;
    }

    private void serveMimetypeImage(String path, HttpServletRequest request, HttpServletResponse response, boolean determineByExtension, int size) {
        URL urlToServe;
        path = determineByExtension ? path.substring(PATH_MIMETYPE_BY_NAME.length()) : path.substring(PATH_MIMETYPE.length());
        ImagesConnector imagesConnector = this.getImagesConnector();
        URL uRL = urlToServe = determineByExtension ? imagesConnector.getMimetypeImageByFileName(path, size) : imagesConnector.getMimetypeImage(path, size);
        if (urlToServe == null) {
            this.serveEmptyImage(request, response);
            return;
        }
        this.serveStaticContent(urlToServe, urlToServe.getFile(), request, response, true);
    }

    private void serveDataImage(String path, HttpServletRequest request, HttpServletResponse response, int size) {
        String key;
        URL urlToServe;
        if (!LoginManager.forceLogin((HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        ImagesConnector imagesConnector = (ImagesConnector)serverPluginManager.getSingleInstance(ImagesConnector.class);
        path = path.substring(PATH_DATA.length());
        String[] parts = path.split("/");
        int typeID = -1;
        if (!StringFunctions.isEmpty((String)parts[0])) {
            typeID = Integer.parseInt(parts[0]);
        }
        StringBuilder b = new StringBuilder();
        if (parts.length > 1) {
            for (int i = 1; i < parts.length; ++i) {
                if (i > 1) {
                    b.append('/');
                }
                b.append(parts[i]);
            }
        }
        if ((urlToServe = imagesConnector.getDataImage(typeID, key = b.toString(), size)) == null) {
            this.serveEmptyImage(request, response);
            return;
        }
        this.serveStaticContent(urlToServe, urlToServe.getFile(), request, response, true);
    }

    private void serveDeviceTypeImage(String path, HttpServletRequest request, HttpServletResponse response, int size) {
        if (!LoginManager.forceLogin((HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        ImagesConnector imagesConnector = (ImagesConnector)serverPluginManager.getSingleInstance(ImagesConnector.class);
        path = path.substring(PATH_DEVICETYPE.length());
        URL urlToServe = null;
        try {
            int deviceTypeID = Integer.parseInt(path);
            urlToServe = imagesConnector.getDeviceTypeImage(deviceTypeID, size);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (urlToServe == null) {
            this.serveEmptyImage(request, response);
            return;
        }
        this.serveStaticContent(urlToServe, urlToServe.getFile(), request, response, true);
    }

    private void serveFieldTypeImage(String path, HttpServletRequest request, HttpServletResponse response, int size) {
        if (!LoginManager.forceLogin((HttpServletRequest)request, (HttpServletResponse)response)) {
            return;
        }
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        ImagesConnector imagesConnector = (ImagesConnector)serverPluginManager.getSingleInstance(ImagesConnector.class);
        path = path.substring(PATH_FIELDTYPE.length());
        URL urlToServe = null;
        urlToServe = imagesConnector.getFieldTypeImage(path, size);
        if (urlToServe == null) {
            this.serveEmptyImage(request, response);
            return;
        }
        this.serveStaticContent(urlToServe, urlToServe.getFile(), request, response, true);
    }

    private void serveEmptyImage(HttpServletRequest request, HttpServletResponse response) {
        this.serveEmptyImage(request, response, 16, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveEmptyImage(HttpServletRequest request, HttpServletResponse response, int width, int height) {
        byte[] emptyImg = new byte[]{};
        ImagesServlet imagesServlet = this;
        synchronized (imagesServlet) {
            String key = width + "x" + height;
            emptyImg = EMPTY_IMAGES.get(key);
            if (emptyImg == null) {
                emptyImg = new byte[]{};
                BufferedImage image = new BufferedImage(width, height, 2);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)image, "png", baos);
                    baos.flush();
                    emptyImg = baos.toByteArray();
                }
                catch (IOException ioe) {
                    HDLogger.error(ioe);
                }
                EMPTY_IMAGES.put(key, emptyImg);
            }
        }
        ServletUtils.setExpirationHeader((HttpServletResponse)response, (long)86400000L);
        try {
            ServletUtils.sendStaticContent((String)"image/png", (long)System.currentTimeMillis(), (long)-1L, (InputStream)new ByteArrayInputStream(emptyImg), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (IOException e) {
            HDLogger.error(e);
            ServletErrorHandler.sendErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="It's the porpose of this methode to deliver an image from and URL that is generated internally.")
    private void serveStaticContent(URL imageUrl, String imageName, HttpServletRequest request, HttpServletResponse response, boolean allowCaching) {
        InputStream inputStream = null;
        try {
            if (imageUrl == null) {
                ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            URLConnection connection = imageUrl.openConnection();
            String mimeType = connection.getContentType();
            if (mimeType == null) {
                mimeType = MimeTypes.getMimeType((String)imageUrl.getFile());
            }
            if (!mimeType.toLowerCase().startsWith("image/")) {
                ServletUtils.sendFileNotExist((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            ServletUtils.setExpirationHeader((HttpServletResponse)response, (long)(allowCaching ? 43200000L : 30000L));
            ServletUtils.sendStaticContent((URLConnection)connection, (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        catch (Throwable e) {
            HDLogger.error(e);
            ServletErrorHandler.sendErrorPage((HttpServletRequest)request, (HttpServletResponse)response, (Throwable)e);
            return;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

