/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.mail.reader;

import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailProtocol;
import com.inet.helpdesk.mail.reader.EmailReader_HDProcessing;
import com.inet.helpdesk.mail.reader.MailType;
import com.inet.helpdesk.mail.reader.RawReadMailData;
import com.inet.mail.api.AttachedFile;
import com.inet.mail.api.MailAttachmentUtilities;
import com.inet.mail.api.MailEncodingUtilities;
import com.inet.mail.api.PartHandler;
import jakarta.mail.Address;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessageRemovedException;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.SharedByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.CancellationException;
import srv.mail.Mail;
import srv.mail.MailFileMethods;
import srv.mail.MessagePartsChecker;
import srv.mail.TicketIdIdentifier;

public class EmailReader_RawReader {
    public static final String FROM = "From";
    public static final String CC = "Cc";
    public static final String TO = "To";
    private static final int CRITICAL_HTML_SIZE = 750000;
    private static final int CRITICAL_PLAINTEXT_SIZE = 25000;
    private MailFileMethods mailFileMethods;
    private boolean connectionCut;

    public EmailReader_RawReader(MailFileMethods mailFileMethods) {
        this.mailFileMethods = mailFileMethods;
    }

    public RawReadMailData readRawMailData(Message msg, EmailAccount emailAccount) {
        this.connectionCut = false;
        try {
            EmailReader_HDProcessing.LOGGER.info((Object)("Reading email subject: \"" + msg.getSubject() + "\" - at " + new Date().toString() + " size (bytes): " + msg.getSize() + " - received at: " + String.valueOf(msg.getReceivedDate())));
        }
        catch (MessagingException ex) {
            EmailReader_HDProcessing.LOGGER.debug((Object)ex);
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)bos);
                bos.close();
                SharedByteArrayInputStream bis = new SharedByteArrayInputStream(bos.toByteArray());
                Session session = msg.getSession();
                msg = new MimeMessage(session, (InputStream)bis);
                bis.close();
                EmailReader_HDProcessing.LOGGER.info((Object)("Reading email subject: \"" + msg.getSubject() + "\" - at " + new Date().toString() + " size (bytes): " + msg.getSize() + " - received at: " + String.valueOf(msg.getReceivedDate())));
            }
            catch (Exception didNotWork) {
                EmailReader_HDProcessing.LOGGER.error((Throwable)new Exception("Error from Mail server: " + didNotWork.getMessage(), didNotWork));
            }
        }
        RawReadMailData result = this.readFromToAndCC(msg);
        this.readContentData(msg, emailAccount, result);
        if (this.connectionCut) {
            throw new CancellationException();
        }
        try {
            result.setReceiveDate(msg.getReceivedDate().getTime());
        }
        catch (Exception ex) {
            result.setReceiveDate(System.currentTimeMillis());
        }
        EmailReader_RawReader.readValuesFromHeader(result, (Part)msg);
        return result;
    }

    private void readContentData(Message msg, EmailAccount emailAccount, RawReadMailData result) {
        try {
            ArrayList<PartHandler> parts = new ArrayList<PartHandler>();
            MailAttachmentUtilities.fetchParts((Part)msg, parts, (boolean)false);
            MessagePartsChecker partChecker = new MessagePartsChecker(this.mailFileMethods, EmailReader_HDProcessing.EMAIL_MESSAGES, EmailReader_HDProcessing.IGNORE_MAP, 25000, 750000);
            String[] mailData = new String[1];
            MessagePartsChecker.CheckPartsResult checkPartResult = partChecker.checkParts(parts, mailData, result.getAttachments(), emailAccount.getProtocol() != EmailProtocol.POP3, TicketIdIdentifier.idsString[0]);
            result.setContent(mailData[0]);
            result.setMailType(MailType.of(checkPartResult.getMailType()));
            result.setAcknowledgeString(checkPartResult.getAcknowledge());
            result.setPossibleTicketIdFromAttachment(checkPartResult.getPossibleId());
            result.setErrorInAttachments(checkPartResult.isErrorInAttachment());
            result.setSubject(MailEncodingUtilities.tryEncoding((String)msg.getSubject(), (boolean)true, (boolean)false));
        }
        catch (Exception er2) {
            result.setMailType(MailType.TEXT);
            if (this.connectionCut) {
                throw new CancellationException();
            }
            EmailReader_HDProcessing.LOGGER.error((Throwable)er2);
            result.setAcknowledgeString("Error: " + String.valueOf(er2));
            AttachedFile anlage = new AttachedFile(MailAttachmentUtilities.getFileName((String)"Message", (String)".mim", result.getAttachments()));
            anlage.setFile(this.mailFileMethods.getFile(anlage.getFileName()));
            if (result.getContent() == null) {
                result.setContent(this.mailFileMethods.writeToFile(anlage.getFile(), msg, true));
            } else {
                this.mailFileMethods.writeToFile(anlage.getFile(), msg, false);
            }
            result.getAttachments().add(anlage);
        }
        if (result.getContent() == null) {
            result.setContent("");
        }
    }

    private RawReadMailData readFromToAndCC(Message msg) {
        RawReadMailData result = new RawReadMailData();
        try {
            InternetAddress address;
            Address[] froms = null;
            String senderMail = null;
            String senderName = null;
            try {
                froms = msg.getFrom();
            }
            catch (MessageRemovedException mre) {
                EmailReader_HDProcessing.LOGGER.error((Throwable)mre);
            }
            if (froms != null && froms.length > 0 && (senderMail = (address = ((InternetAddress[])froms)[0]).getAddress()) != null) {
                if (senderMail.indexOf(61) > -1) {
                    senderMail = senderMail.substring(senderMail.lastIndexOf(61) + 1);
                }
                if (senderMail.length() > 99) {
                    senderMail = senderMail.substring(0, 99);
                }
                if ((senderName = address.getPersonal()) == null) {
                    senderName = senderMail;
                }
            }
            result.setSenderMail(senderMail);
            result.setSenderName(senderName);
            result.setReceiverMail(Mail.getAddressString(msg.getRecipients(Message.RecipientType.TO)));
            result.setReceiverCCMail(Mail.getAddressString(msg.getRecipients(Message.RecipientType.CC)));
            if (this.connectionCut) {
                throw new CancellationException();
            }
        }
        catch (Exception er2) {
            EmailReader_HDProcessing.LOGGER.error((Throwable)er2);
            if (this.connectionCut) {
                throw new CancellationException();
            }
            try {
                String[] from = EmailReader_RawReader.getAddressFromHeader(msg, FROM);
                result.setSenderMail(from[0]);
                result.setSenderName(from[1]);
                result.setReceiverMail(EmailReader_RawReader.getAddressFromHeader(msg, TO)[0]);
                result.setReceiverCCMail(EmailReader_RawReader.getAddressFromHeader(msg, CC)[0]);
            }
            catch (Exception innerException) {
                EmailReader_HDProcessing.LOGGER.error((Throwable)innerException);
            }
        }
        return result;
    }

    private static String[] getAddressFromHeader(Message msg, String headerName) throws MessagingException {
        String[] headerArray = msg.getHeader(headerName);
        String[] retVal = new String[]{null, null};
        if (headerArray == null) {
            EmailReader_HDProcessing.LOGGER.debug((Object)("No result for: getHeader(\"" + headerName + "\")"));
        } else {
            EmailReader_HDProcessing.LOGGER.debug((Object)("Header \"" + headerName + "\" lines: " + headerArray.length));
            for (int i = 0; i < headerArray.length; ++i) {
                String headerLine = headerArray[i];
                EmailReader_HDProcessing.LOGGER.debug((Object)(i + 1 + ". Header: -" + headerLine + "-"));
                if (headerLine.indexOf(60) > -1 && headerLine.indexOf(62) > headerLine.indexOf(60)) {
                    retVal[0] = headerLine.substring(headerLine.indexOf(60) + 1, headerLine.indexOf(62));
                    int perso = headerLine.indexOf(34);
                    if (perso > -1 && headerLine.indexOf(34, perso + 2) > -1) {
                        retVal[1] = headerLine.substring(perso + 1, headerLine.indexOf(34, perso + 2));
                        continue;
                    }
                    if (retVal[0].indexOf(64) > -1) {
                        retVal[1] = retVal[0].substring(0, retVal[0].indexOf(64));
                        continue;
                    }
                    retVal[1] = retVal[0];
                    continue;
                }
                if (headerLine.indexOf(34) != -1 || headerLine.indexOf(64) <= -1) continue;
                retVal[0] = headerLine.trim();
                retVal[1] = retVal[0].indexOf(64) > -1 ? retVal[0].substring(0, retVal[0].indexOf(64)) : retVal[0];
            }
        }
        return retVal;
    }

    public void abortReading() {
        this.connectionCut = true;
    }

    private static void readValuesFromHeader(RawReadMailData result, Part part) {
        Map<String, String> headerMap = result.getHeaderValues();
        try {
            EmailReader_HDProcessing.LOGGER.debug((Object)("PART: " + part.getClass().getName()));
            Enumeration allHeaders = part.getAllHeaders();
            while (allHeaders.hasMoreElements()) {
                Header header = (Header)allHeaders.nextElement();
                if (header == null) continue;
                String value = MimeUtility.decodeText((String)header.getValue());
                EmailReader_HDProcessing.LOGGER.debug((Object)("HEADER: -" + header.getName() + "-" + value));
                if ("X-SendIdent".equalsIgnoreCase(header.getName())) {
                    headerMap.put("foreign key", value);
                    continue;
                }
                if ("X-SendReference".equalsIgnoreCase(header.getName())) {
                    headerMap.put("local key", value);
                    continue;
                }
                headerMap.put(header.getName().toLowerCase(), value);
            }
        }
        catch (Exception ex) {
            EmailReader_HDProcessing.LOGGER.error((Throwable)ex);
        }
    }
}

