/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.itil;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ItilLinkCache {
    private final Map<Integer, Set<Integer>> masterToSlaveIDs = new HashMap<Integer, Set<Integer>>();
    private final Set<Integer> linkedItilSlaves = new HashSet<Integer>();

    public synchronized void addLink(int masterID, int slaveID) {
        this.masterToSlaveIDs.computeIfAbsent(masterID, k -> new HashSet()).add(slaveID);
        this.linkedItilSlaves.add(slaveID);
    }

    public synchronized void removeLink(int masterID, int slaveID) {
        Set<Integer> slaves = this.masterToSlaveIDs.get(masterID);
        if (slaves != null) {
            slaves.remove(slaveID);
            if (slaves.isEmpty()) {
                this.masterToSlaveIDs.remove(masterID);
            }
        }
        this.linkedItilSlaves.remove(slaveID);
    }

    public synchronized void removeAllLinks(int masterID) {
        Set<Integer> slaves = this.masterToSlaveIDs.get(masterID);
        if (slaves != null) {
            this.linkedItilSlaves.removeAll(slaves);
            this.masterToSlaveIDs.remove(masterID);
        }
    }

    public synchronized int getItilLinkCount(int ticketID) {
        if (this.masterToSlaveIDs.containsKey(ticketID)) {
            return this.masterToSlaveIDs.get(ticketID).size();
        }
        if (this.linkedItilSlaves.contains(ticketID)) {
            return 1;
        }
        return 0;
    }

    public synchronized Set<Integer> getItilSlavesLinkedTo(int ticketID) {
        Set<Integer> slaveIDs = this.masterToSlaveIDs.get(ticketID);
        if (slaveIDs == null) {
            return Collections.emptySet();
        }
        return new HashSet<Integer>(slaveIDs);
    }

    public synchronized Set<Integer> getItilMastersLinkedToSlaves() {
        return new HashSet<Integer>(this.masterToSlaveIDs.keySet());
    }

    @Nullable
    public synchronized Integer getItilMasterOf(int ticketId) {
        for (Map.Entry<Integer, Set<Integer>> en : this.masterToSlaveIDs.entrySet()) {
            if (!en.getValue().contains(ticketId)) continue;
            return en.getKey();
        }
        return null;
    }
}

