/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data;

import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.search.rpc.UserListFilterCondition;
import com.inet.search.command.SearchCondition;
import java.util.ArrayList;
import java.util.List;

public class SearchConditionCreator {
    public ArrayList<SearchCondition> createSearchTermsFrom(List<UserListFilterCondition> conditions) {
        ArrayList<SearchCondition> result = new ArrayList<SearchCondition>();
        if (conditions == null) {
            return result;
        }
        block8: for (UserListFilterCondition cond : conditions) {
            UserListFilterCondition.FilterConditionOperator op = cond.getFilterOperator();
            UserListFilterCondition.FilterConditionField op1 = cond.getOperand1();
            SearchCondition.SearchTermOperator searchOp = switch (op) {
                case UserListFilterCondition.FilterConditionOperator.isEqual -> SearchCondition.SearchTermOperator.Equals;
                default -> SearchCondition.SearchTermOperator.StartsWith;
            };
            String op1String = null;
            switch (op1) {
                case Location: {
                    op1String = Field.USERDATA_LOCATION_DISPLAYNAME.name();
                    result.add(new SearchCondition(op1String, searchOp, (Object)cond.getOperand2()));
                    continue block8;
                }
                case EmailUser: 
                case Group: 
                case EmailAddress: 
                case Resource: 
                case TouchedTicket: 
                case Supporter: 
                case Permission: {
                    continue block8;
                }
                case UserField: {
                    String fieldName = cond.getOperand1FieldName();
                    SearchCondition c = new SearchCondition(fieldName, searchOp, (Object)cond.getOperand2());
                    result.add(c);
                    continue block8;
                }
            }
            SearchCondition c = new SearchCondition(op1String, searchOp, (Object)cond.getOperand2());
            result.add(c);
        }
        return result;
    }
}

