/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.model;

import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import javax.annotation.Nonnull;

public class ActionCheckError {
    private String errorMessage;
    private ErrorCode errorCode;

    private ActionCheckError(@Nonnull String errorMessage, @Nonnull ErrorCode errorCode) {
        if (errorMessage == null) {
            errorMessage = "";
        }
        this.errorMessage = errorMessage;
        this.errorCode = errorCode;
    }

    @Nonnull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nonnull
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        return this.getErrorMessage();
    }

    public static ActionCheckError createForIllegalTicketState(@Nonnull String errorMessage) {
        return new ActionCheckError(errorMessage, HelpDeskErrorCodes.TICKET_OPERATION_NOT_POSSIBLE_WRONG_STATE);
    }

    public static ActionCheckError createForTicketSettingMismatch(@Nonnull String errorMessage) {
        return new ActionCheckError(errorMessage, HelpDeskErrorCodes.TICKET_OPERATION_NOT_POSSIBLE_WRONG_SETTING);
    }

    public static ActionCheckError createForAccessDenied(@Nonnull String errorMessage) {
        return new ActionCheckError(errorMessage, (ErrorCode)BaseErrorCode.forbidden);
    }

    public static ActionCheckError createForNotLoggedIn(@Nonnull String errorMessage) {
        return new ActionCheckError(errorMessage, (ErrorCode)BaseErrorCode.UserNotLoggedIn);
    }

    public static ActionCheckError createForGivenCode(@Nonnull String errorMessage, ErrorCode code) {
        return new ActionCheckError(errorMessage, code);
    }

    public static ActionCheckError createForIllegalArgument(@Nonnull String errorMessage) {
        return new ActionCheckError(errorMessage, HelpDeskErrorCodes.FATAL_ERROR);
    }
}

