/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;

public class TicketFieldDefinitionTicketOwnerLocationId
extends AbstractTicketFieldDefinitionForTicketOwner {
    public TicketFieldDefinitionTicketOwnerLocationId(UserFieldDefinition<?> fieldDef, int prio) {
        super(fieldDef, prio);
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation("ticketowner." + String.valueOf((Object)HDUsersAndGroups.FIELD_LOCATION_ID), sortGroupKey -> {
            if (StringFunctions.isEmpty((String)sortGroupKey)) {
                return new SortGroup(Tickets.MSG.getMsg("value.unset", new Object[0]), false, null);
            }
            String displayName = ((LocationVO)LocationManager.getInstance().get(Integer.parseInt(sortGroupKey))).getDisplayValue();
            return new SortGroup(displayName, false, null);
        }){

            @Override
            public String getSortGroupKey(TicketVO ticket) {
                Integer locationID;
                GUID ownerID = ticket.getOwnerID();
                if (ownerID == null) {
                    return null;
                }
                UserAccount userAccount = UserManager.getInstance().getUserAccount(ownerID);
                if (userAccount != null && (locationID = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID)) != null) {
                    return locationID.toString();
                }
                return null;
            }
        };
    }
}

