/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.field.ConfigurableDefaultValue;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionWithGenericFieldsManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.ItilSelectOption;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class TicketFieldDefinitionItilId
extends AbstractTicketFieldDefinitionWithGenericFieldsManager
implements ConfigurableDefaultValue,
ConfigurableMandatoryField<Integer> {
    public TicketFieldDefinitionItilId(int prio) {
        super(Tickets.FIELD_ITIL_ID, ItilManager.getInstance(), prio);
    }

    @Override
    public FieldEditDefinition getEditDefinition() {
        return new SelectEditDefinition(this){

            @Override
            public void updateTicketData(MutableTicketData ticketData, Map<String, String> values) {
                String value = values.get(this.getFieldKey());
                if (!StringFunctions.isEmpty((String)value)) {
                    Integer itilId;
                    SelectOption selectOption = null;
                    selectOption = (SelectOption)new Json().fromJson(value, ItilSelectOption.class);
                    String valueString = selectOption.getValue();
                    if (!StringFunctions.isEmpty((String)valueString) && (itilId = Integer.valueOf(selectOption.getValue())) != null) {
                        ticketData.put(Tickets.FIELD_ITIL_ID, itilId);
                    }
                }
            }

            @Override
            public void updateCurrentValue(TicketVO ticket, GUID ownerId, Map<String, String> values) {
                ItilVO itilVO;
                Integer itilId = TicketFieldDefinitionItilId.this.defaultValue();
                if (ticket != null) {
                    itilId = ticket.getItilID();
                }
                SelectOption option = new SelectOption(null, "");
                if (itilId != null && (itilVO = (ItilVO)ItilManager.getInstance().get(itilId)) != null) {
                    option = new SelectOption(String.valueOf(itilId), itilVO.getDisplayValue(), String.valueOf(itilVO.getId()));
                }
                values.put(this.getFieldKey(), new Json().toJson((Object)option));
            }

            @Override
            public String getFieldKey() {
                return TicketFieldDefinitionItilId.this.getKey();
            }

            @Override
            public String getDisplayName() {
                return TicketFieldDefinitionItilId.this.getDisplayName();
            }

            @Override
            public String getDisplayType() {
                return "itilselect";
            }

            @Override
            public SelectOptionResult getSelectOptions(List<TicketVO> tickets, String searchTerm, int chunkSize, int currentSize) {
                ArrayList<SelectOption> list = new ArrayList<SelectOption>();
                Comparator comparator = (o1, o2) -> {
                    if (o1.isMasterType() && !o2.isMasterType()) {
                        return 1;
                    }
                    if (!o1.isMasterType() && o2.isMasterType()) {
                        return -1;
                    }
                    return o1.getDisplayValue().compareToIgnoreCase(o2.getDisplayValue());
                };
                searchTerm = searchTerm != null ? searchTerm : "";
                ItilManager manager = ItilManager.getInstance();
                List itils = manager.getAll(true);
                itils.sort(comparator);
                for (ItilVO itilVO : itils) {
                    String itilDisplayValue = itilVO.getDisplayValue();
                    if (itilDisplayValue == null) {
                        itilDisplayValue = "";
                    }
                    if (!itilDisplayValue.toLowerCase().contains(searchTerm.toLowerCase()) || !ItilManager.getInstance().isUsableByCurrentUser(itilVO.getId())) continue;
                    list.add(this.createOption(itilVO));
                }
                if (list.size() < currentSize) {
                    return new SelectOptionResult(0, new ArrayList());
                }
                List subList = list.subList(currentSize, Math.min(list.size(), currentSize + chunkSize));
                return new SelectOptionResult(list.size(), subList);
            }

            private SelectOption createOption(ItilVO itilVO) {
                String parent = null;
                parent = itilVO.isMasterType() ? Tickets.MSG.getMsg("default.ticket.itil.master", new Object[0]) : Tickets.MSG.getMsg("default.ticket.itil.slave", new Object[0]);
                return new ItilSelectOption(String.valueOf(itilVO.getId()), itilVO.getDisplayValue(), String.valueOf(itilVO.getId()), itilVO.getInfo(), parent);
            }
        };
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/itil_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/itil_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/itil_16@3x.png");
    }

    public void setDefaultValue(@Nullable String value) {
        this.getField().setDefaultValue((Integer)this.getField().getFieldType().valueOf(value));
    }
}

