/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketmanager.fielddefinitions;

import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.ByIDSortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroup;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinitionHDCore;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.util.StringFunctions;
import java.net.URL;
import java.util.Comparator;
import javax.annotation.Nullable;

public class TicketFieldDefinitionBundleImage
extends TicketFieldDefinition
implements TicketFieldDefinitionHDCore {
    public TicketFieldDefinitionBundleImage(int prio) {
        super(TicketFieldDefinition.FIELD_GROUPING.TICKET, "bundleImage", false, true, prio);
    }

    @Override
    public String getLabel() {
        return Tickets.MSG.getMsg(ClientLocale.getThreadLocale(), "field.bundleimage", new Object[0]);
    }

    @Override
    public URL getColumnIcon(Integer iconSize) {
        if (iconSize <= 16) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/ticket_bunch_16.png");
        }
        if (iconSize <= 32) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/ticket_bunch_16@2x.png");
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/ticketfield/ticket_bunch_16@3x.png");
    }

    @Override
    public String getValueAsStringForIcon(TicketVO ticket) {
        if (ticket.isUnbundled()) {
            return null;
        }
        return String.valueOf(true);
    }

    @Override
    public URL getIconForValue(String valueAsString, int size) {
        if (StringFunctions.isEmpty((String)valueAsString)) {
            return null;
        }
        if (Boolean.parseBoolean(valueAsString)) {
            return this.getClass().getResource("/com/inet/helpdesk/images/ticket_bunch_16.gif");
        }
        return null;
    }

    @Override
    public SortGroupInformation getSortGroupInformation() {
        return new ByIDSortGroupInformation("bundleImage", sortGroupKey -> {
            String displayName = Tickets.MSG.getMsg("field.bundleimage.nobundle", new Object[0]);
            if ("true".equalsIgnoreCase((String)sortGroupKey)) {
                displayName = Tickets.MSG.getMsg("field.bundleimage.bundled", new Object[0]);
            }
            String iconKey = sortGroupKey;
            return new SortGroup(displayName, "true".equalsIgnoreCase((String)sortGroupKey), iconKey);
        }){

            @Override
            public String getSortGroupKey(TicketVO ticket) {
                return String.valueOf(!ticket.isUnbundled());
            }
        };
    }

    @Override
    public String getDisplayValue(TicketVO ticket) {
        return null;
    }

    @Override
    public Comparator<TicketVO> getComparator() {
        return (a, b) -> Boolean.valueOf(!a.isUnbundled()).compareTo(!b.isUnbundled());
    }

    @Override
    @Nullable
    public FieldSettingsType getDisplayType() {
        return null;
    }
}

