/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketfieldsettings;

import com.inet.classloader.I18nMessages;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.ConfigurableField;
import com.inet.field.FieldManager;
import com.inet.fieldsettings.api.AbstractFieldSettingsManager;
import com.inet.fieldsettings.api.FieldSettingsStructureInfo;
import com.inet.fieldsettings.api.model.FieldSettingsType;
import com.inet.fieldsettings.api.model.GenericFieldSetting;
import com.inet.fieldsettings.api.model.nature.CustomNature;
import com.inet.fieldsettings.api.model.nature.GenericFieldNature;
import com.inet.fieldsettings.api.model.nature.RegisteredNature;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketfieldsettings.ConfigurableMandatoryField;
import com.inet.helpdesk.core.ticketfieldsettings.RegisteredTicketNature;
import com.inet.helpdesk.core.ticketfieldsettings.SqlQuerySelectValueProvider;
import com.inet.helpdesk.core.ticketfieldsettings.TicketFieldSettings;
import com.inet.helpdesk.core.ticketfieldsettings.fields.CustomTicketField;
import com.inet.helpdesk.core.ticketfieldsettings.fields.CustomTicketFieldDefinition;
import com.inet.helpdesk.core.ticketfieldsettings.fields.TicketFieldDefinitionLink;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManagerVetoPower;
import com.inet.helpdesk.core.ticketmanager.fields.MandatoryFieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketFieldOpenField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.subview.TicketFieldSubViewGrouping;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.plugin.veto.VetoType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TicketFieldSettingsManager
extends AbstractFieldSettingsManager<TicketFieldDefinition, TicketField<?>> {
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.core.ticketfieldsettings.config.i18n.ConfigStructure", TicketFieldSettingsManager.class);
    private static final TicketFieldSettingsManager INSTANCE = new TicketFieldSettingsManager();

    public static TicketFieldSettingsManager getInstance() {
        return INSTANCE;
    }

    public TicketFieldSettingsManager() {
        super("TicketFields", HDLogger.LOG);
    }

    public void init() {
        GenericFieldSetting settingCustom3;
        super.init();
        if (this.getSetting("custom1") == null) {
            List<String> toadd = List.of("custom1", "custom2", "custom3", "custom4", "custom6", "custom5", "custom7");
            for (String key : toadd) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("fieldsettingsKey", key);
                properties.put("sortPrio", String.valueOf(140 + toadd.indexOf(key) * 10));
                properties.put("type", key.equals("custom5") ? FieldSettingsType.TYPE_MULTILINE_TEXT.toString() : FieldSettingsType.TYPE_TEXT.toString());
                if (key.equals("custom3")) {
                    properties.put("ticketCustom3", "true");
                }
                this.setSpecificDefaultValues(null, properties);
                GenericFieldSetting setting = new GenericFieldSetting(key, true, "", (GenericFieldNature)new CustomNature(properties), properties);
                Map.Entry customField = this.saveNewCustomSetting(key, setting);
                this.registerTranslationKeys((TicketFieldDefinition)customField.getKey());
                this.updateConfigurableValuesOfField((TicketFieldDefinition)customField.getKey(), setting);
            }
        }
        if ((settingCustom3 = this.getSetting("custom3")).getSpecificProperty("ticketCustom3") == null) {
            Map properties = settingCustom3.toMap((AbstractFieldSettingsManager)this);
            properties.put("ticketCustom3", "true");
            this.updateSetting("custom3", properties);
        }
    }

    public void updateSetting(String key, Map<String, String> properties) {
        if (key.equals("custom3")) {
            properties.put("ticketCustom3", "true");
        }
        super.updateSetting(key, properties);
    }

    protected <T> Map.Entry<TicketFieldDefinition, TicketField<?>> createAndRegisterForCustom(GenericFieldSetting setting) {
        CustomTicketField field = null;
        TicketFieldDefinition def = null;
        if (setting.getKey().equals("custom1") || setting.getKey().equals("custom2") || setting.getKey().equals("custom3") || setting.getKey().equals("custom4") || setting.getKey().equals("custom5") || setting.getKey().equals("custom6") || setting.getKey().equals("custom7")) {
            field = new TicketFieldOpenField(setting.getKey(), setting);
            def = new CustomTicketFieldDefinition(field, setting);
        } else if (setting.getType() == FieldSettingsType.TYPE_LINK) {
            def = new TicketFieldDefinitionLink(setting);
        } else {
            field = new CustomTicketField(setting.getKey(), setting, null);
            def = new CustomTicketFieldDefinition(field, setting);
        }
        if (field != null) {
            DynamicExtensionManager.getInstance().register(TicketField.class, field);
            DynamicExtensionManager.getInstance().register(SubViewGroupingDefinition.class, (Object)new TicketFieldSubViewGrouping(field.getKey()));
        }
        DynamicExtensionManager.getInstance().register(TicketFieldDefinition.class, def);
        HashMap xx = new HashMap();
        xx.put(def, field);
        return xx.entrySet().iterator().next();
    }

    protected void deleteFields(List<TicketField<?>> arg0) {
        TicketManager.getMaintenance().clearAllTicketsInCache();
        TicketManager.getMaintenance().deleteDataOfDeletedField(arg0);
    }

    protected Map<String, String> copyPropertiesAndRemoveGUIKeys(Map<String, String> properties) {
        Map map = super.copyPropertiesAndRemoveGUIKeys(properties);
        map.remove("ticketFieldMandatoryAllowed");
        map.remove("ticketFieldEnduserEditableXDefaultChange");
        map.remove("catLink");
        map.remove("classLink");
        map.remove("prioLink");
        map.remove("itilLink");
        return map;
    }

    protected List<TicketFieldDefinition> getAllRegisteredDefinitions() {
        List all = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        ArrayList<TicketFieldDefinition> result = new ArrayList<TicketFieldDefinition>();
        all.forEach(def -> {
            try {
                RegisteredTicketNature.getTypeForDefinition(def);
            }
            catch (IllegalArgumentException notsupportet) {
                return;
            }
            result.add((TicketFieldDefinition)def);
        });
        return result;
    }

    public FieldSettingsStructureInfo getFieldSettingsStructureInfo() {
        return new FieldSettingsStructureInfo(AbstractFieldSettingsManager.BASE_TRANSLATIONS){

            public String getIconKeyRegisteredField() {
                return "ticket-default";
            }

            public String getIconKeyCustomField() {
                return "ticket-custom";
            }

            public String getHelpKey() {
                return "field.settings.ticket.edit";
            }

            public String getFieldKindLabel() {
                return MSG.getMsg("ticketfield.single.name", new Object[0]);
            }
        };
    }

    protected TicketField<?> getIndexInfoForRegisteredField(TicketFieldDefinition arg0) {
        return Tickets.getFieldByKey(arg0.getKey());
    }

    public FieldManager<Integer> getManager() {
        return TicketManager.getReader();
    }

    protected RegisteredNature getRegisteredNatureFor(TicketFieldDefinition arg0) {
        return new RegisteredTicketNature(arg0);
    }

    protected String setSpecificDefaultValues(@Nullable TicketFieldDefinition registeredDef, Map<String, String> specificProps) {
        if (registeredDef != null) {
            TicketField field;
            if (registeredDef instanceof ConfigurableMandatoryField) {
                field = ((ConfigurableMandatoryField)((Object)registeredDef)).getField();
                specificProps.putIfAbsent("ticketFieldEnduserEditable", field.getEnduserEditability().name());
                specificProps.putIfAbsent("ticketFieldMandatoryDispatcher", String.valueOf(field.isMandatoryForDispatcher()));
                specificProps.putIfAbsent("ticketFieldMandatorySupporter", String.valueOf(field.isMandatoryForResourceMember()));
                specificProps.putIfAbsent("ticketFieldMandatoryDispatcherDefaultMustbeChanged", String.valueOf(field.isDefaultMustBeChangedForDispatcher()));
                specificProps.putIfAbsent("ticketFieldMandatorySupporterDefaultMustbeChanged", String.valueOf(field.isDefaultMustBeChangedForResourceMember()));
            }
            specificProps.putIfAbsent("ticketFieldVisibility", registeredDef.getVisibility().name());
            field = Tickets.getFieldByKey(registeredDef.getFieldKey());
            if (field != null) {
                Object defaultValue = field.getDefaultValue();
                return defaultValue == null ? null : field.getFieldType().asString(defaultValue);
            }
            return null;
        }
        specificProps.putIfAbsent("ticketFieldEnduserEditable", MandatoryFieldVO.MandatoryType.HIDDEN.name());
        specificProps.putIfAbsent("ticketFieldMandatoryDispatcher", String.valueOf("false"));
        specificProps.putIfAbsent("ticketFieldMandatorySupporter", String.valueOf("false"));
        specificProps.putIfAbsent("ticketFieldVisibility", TicketFieldDefinition.FIELD_VISIBILITY.SUPPORTER.name());
        SqlQuerySelectValueProvider.setDefaultValuesForSqlProperties(specificProps);
        return null;
    }

    protected void updateConfigurableValuesOfField(TicketFieldDefinition definition, GenericFieldSetting setting) {
        super.updateConfigurableValuesOfField((ConfigurableField)definition, setting);
        String visibility = setting.getSpecificProperty("ticketFieldVisibility");
        if (visibility != null) {
            definition.setVisibility(TicketFieldDefinition.FIELD_VISIBILITY.valueOf(visibility));
        }
        if (definition instanceof ConfigurableMandatoryField) {
            TicketField field = ((ConfigurableMandatoryField)((Object)definition)).getField();
            field.setMandatoryForDispatcher(Boolean.valueOf(setting.getSpecificProperty("ticketFieldMandatoryDispatcher")));
            field.setMandatoryForResourceMember(Boolean.valueOf(setting.getSpecificProperty("ticketFieldMandatorySupporter")));
            field.setDefaultMustBeChangedForDispatcher(Boolean.valueOf(setting.getSpecificProperty("ticketFieldMandatoryDispatcherDefaultMustbeChanged")));
            field.setDefaultMustBeChangedForResourceMember(Boolean.valueOf(setting.getSpecificProperty("ticketFieldMandatorySupporterDefaultMustbeChanged")));
            String specificProperty = setting.getSpecificProperty("ticketFieldEnduserEditable");
            if (StringFunctions.isEmpty((String)specificProperty)) {
                specificProperty = MandatoryFieldVO.MandatoryType.VISIBLE.toString();
            }
            field.setEnduserEditability(MandatoryFieldVO.MandatoryType.valueOf(specificProperty));
        }
    }

    protected boolean fieldSettingOnlyContainsSimpleChanges(GenericFieldSetting setting, GenericFieldSetting updatedSetting) {
        return !setting.isCustom() || ((CustomNature)setting.getNature()).onlySimpleValueAreDifferent((CustomNature)updatedSetting.getNature());
    }

    protected TicketField<?> unregisterForCustom(GenericFieldSetting setting) {
        TicketField field = Tickets.getFieldByKey(setting.getKey());
        TicketFieldDefinition fieldDefinitionByKey = Tickets.getFieldDefinitionByKey(setting.getKey());
        if (fieldDefinitionByKey != null) {
            DynamicExtensionManager.getInstance().unregister(TicketFieldDefinition.class, (Object)fieldDefinitionByKey);
            if (field != null) {
                DynamicExtensionManager.getInstance().unregister(TicketField.class, field);
                SubViewGroupingDefinition byName = (SubViewGroupingDefinition)DynamicExtensionManager.getInstance().getSingleInstanceByName(SubViewGroupingDefinition.class, setting.getKey(), false);
                DynamicExtensionManager.getInstance().unregister(SubViewGroupingDefinition.class, (Object)byName);
                return field;
            }
        } else {
            HDLogger.warn("Try to remove a non-existing field: " + setting.getKey());
        }
        return null;
    }

    public void deleteCustomSetting(String key) {
        if (TicketFieldSettings.isOpenFieldKey(key)) {
            throw new IllegalArgumentException(MSG.getMsg("error.cannotDeleteOpenFields", new Object[0]));
        }
        super.deleteCustomSetting(key);
    }

    public List<ConfigValidationMsg> validate(String key, Map<String, String> properties, boolean willBeNewField) {
        List result = super.validate(key, properties, willBeNewField);
        String typeStr = properties.get("type");
        boolean isCustom = Boolean.valueOf(properties.get("fieldsettingsIsCustom"));
        if (typeStr != null) {
            FieldSettingsType type = FieldSettingsType.valueOf((String)typeStr);
            if (TicketFieldSettings.isOpenFieldKey(key) && type == FieldSettingsType.TYPE_LINK) {
                result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, MSG.getMsg("fields.validation.openFieldCannotBeLink", new Object[]{type.getLabel()}), "type"));
            }
            if (willBeNewField && result.isEmpty()) {
                List list3;
                List list2;
                List list = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                if (list.stream().anyMatch(d -> Objects.equals(d.getFieldKey(), key))) {
                    result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.reservedkey", new Object[]{key}), "fieldsettingsKey"));
                }
                if (result.isEmpty() && (list2 = DynamicExtensionManager.getInstance().get(TicketField.class)).stream().anyMatch(d -> Objects.equals(d.getKey(), key))) {
                    result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.reservedkey", new Object[]{key}), "fieldsettingsKey"));
                }
                if (result.isEmpty() && (list3 = DynamicExtensionManager.getInstance().get(TicketAttribute.class)).stream().anyMatch(d -> Objects.equals(d.getKey(), key))) {
                    result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, BASE_TRANSLATIONS.getMsg("fields.validation.reservedkey", new Object[]{key}), "fieldsettingsKey"));
                }
            }
            if (type == FieldSettingsType.TYPE_SELECT && isCustom) {
                String defaultValueStr;
                String selectMode;
                List options = (List)new Json().fromJson(properties.get("selectstaticoptions"), List.class);
                HashSet<String> optionStrings = new HashSet<String>();
                boolean anyallowedForEnduser = false;
                for (List line2 : options) {
                    if (optionStrings.contains(line2.get(0))) {
                        result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, MSG.getMsg("fields.validation.duplicateSelectOptions", new Object[]{line2.get(0)}), "selectstaticoptions"));
                    }
                    optionStrings.add((String)line2.get(0));
                    if (!Objects.equals(line2.get(1), "selectForSupporterAndEnduser")) continue;
                    anyallowedForEnduser = true;
                }
                if (!anyallowedForEnduser && !"true".equals(properties.get("usesqlconnection"))) {
                    String enduserVisible = properties.get("ticketFieldEnduserEditable");
                    selectMode = properties.get("fieldSettingsSelectMode");
                    if (!Objects.equals(selectMode, String.valueOf(2)) && !Objects.equals(MandatoryFieldVO.MandatoryType.HIDDEN.name(), enduserVisible)) {
                        result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, MSG.getMsg("fields.validation.noValidValueForEnduser", new Object[]{key}), "selectstaticoptions"));
                    }
                }
                if ((defaultValueStr = properties.get("fieldsettingsDefaultValueSelect")) != null && !Objects.equals(properties.get("ticketFieldEnduserEditable"), MandatoryFieldVO.MandatoryType.HIDDEN.name())) {
                    String defaultValue = ((LocalizedKey)new Json().fromJson(defaultValueStr, LocalizedKey.class)).getKey();
                    for (List line3 : options) {
                        if (!((String)line3.get(0)).equals(defaultValue) || !Objects.equals(line3.get(1), "selectOnlyForSupporter")) continue;
                        result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, MSG.getMsg("fields.validation.defaultMustBeVisibleForEnduser", new Object[]{defaultValue}), "fieldsettingsDefaultValueSelect"));
                        break;
                    }
                }
                selectMode = properties.get("fieldSettingsSelectMode");
                String s1 = properties.get("ticketFieldMandatoryDispatcherDefaultMustbeChanged");
                String s2 = properties.get("ticketFieldMandatorySupporterDefaultMustbeChanged");
                String sEnduser = properties.get("ticketFieldEnduserEditable");
                boolean isCustom3 = key.equals("custom3");
                if (!isCustom3 && !Objects.equals(selectMode, String.valueOf(2)) && (Objects.equals(s1, "true") || Objects.equals(s2, "true") || Objects.equals(sEnduser, MandatoryFieldVO.MandatoryType.REQUIRED.name())) && defaultValueStr != null) {
                    String defaultValue = ((LocalizedKey)new Json().fromJson(defaultValueStr, LocalizedKey.class)).getKey();
                    if (!options.stream().anyMatch(line -> {
                        String value = (String)line.get(0);
                        if (Objects.equals(value, defaultValue)) {
                            return false;
                        }
                        return value != null && !value.isBlank();
                    })) {
                        result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, MSG.getMsg("fields.validation.noValidValueAfterDefaultChange", new Object[]{key}), "selectstaticoptions"));
                    }
                    if (!options.stream().anyMatch(line -> {
                        String value = (String)line.get(0);
                        if (Objects.equals(value, defaultValue)) {
                            return false;
                        }
                        if (value == null || value.isBlank()) {
                            return false;
                        }
                        return !((String)line.get(1)).equals("selectOnlyForSupporter");
                    })) {
                        result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, MSG.getMsg("fields.validation.noValidValueAfterDefaultChange_Enduser", new Object[]{key}), "selectstaticoptions"));
                    }
                }
            }
            SqlQuerySelectValueProvider.validateSQLQuery(properties, result);
            if (key.equals(Tickets.FIELD_CATEGORY_ID.getKey())) {
                List all;
                boolean allHidden;
                String enduserVisible = properties.get("ticketFieldEnduserEditable");
                if (!Objects.equals(MandatoryFieldVO.MandatoryType.HIDDEN.name(), enduserVisible) && (allHidden = (all = CategoryManager.getInstance().getAll(true)).stream().filter(vo -> vo.getId() > 0).allMatch(CategoryVO::isEffectivelyHidden))) {
                    result.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, MSG.getMsg("fields.validation.noValidValueForEnduser", new Object[]{key}), "ticketFieldEnduserEditable"));
                }
            }
        }
        return result;
    }

    protected void sendExternalSignal(List<TicketField<?>> removedInfos, List<TicketField<?>> addedInfos) {
        List removedSearchTags = removedInfos.stream().map(f -> {
            if (f != null) {
                return f.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List addedSearchTags = addedInfos.stream().map(f -> {
            if (f != null) {
                return f.getSearchTag();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        try {
            VetoType veto = VetoManager.getInstance().getCurrentType();
            if (veto != null && veto.compareTo(TicketManagerVetoPower.TYPE) < 0) {
                TicketManagerVetoPower.requestReIndexing();
            } else {
                this.getManager().getSearchEngine().changeTagsAndReindex(removedSearchTags, Collections.emptyList());
                this.getManager().getSearchEngine().changeTagsAndReindex(Collections.emptyList(), addedSearchTags);
            }
        }
        catch (IOException e) {
            HDLogger.LOG.error((Throwable)e);
        }
    }

    protected void sendDeleteUserFieldsAndSendExternalSignal(List<TicketField<?>> fieldsToDelete, List<TicketField<?>> addedInfos) {
        super.sendDeleteUserFieldsAndSendExternalSignal(fieldsToDelete, addedInfos);
        if (fieldsToDelete.isEmpty()) {
            return;
        }
        TicketManager.getMaintenance().clearAllTicketsInCache();
    }

    public List<FieldSettingsType> getSupportedTypesForCustomFields() {
        List types = super.getSupportedTypesForCustomFields();
        types.add(FieldSettingsType.TYPE_RATING);
        return types;
    }
}

