/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.model.ticket;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

@JsonData
public class Ticket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<DataField> data = new ArrayList();
    private int version = -1;
    private boolean htmlContent = false;

    private Ticket() {
    }

    public Ticket(int version, int ticketId, int resourceId, String subject, Date lastModified, int statusId, int prioId) {
        this.version = version;
        this.addData(new DataField(Field.TICKETDATA_TICKETID, (Object)ticketId));
        this.addData(new DataField(Field.TICKETDATA_RESOURCEID, (Object)resourceId));
        this.addData(new DataField(Field.TICKETDATA_STATUSID, (Object)statusId));
        this.addData(new DataField(Field.TICKETDATA_PRIORITYID, (Object)prioId));
        this.addData(new DataField(Field.TICKETDATA_SUBJECT, (Object)subject));
        this.addData(new DataField(Field.TICKETDATA_LASTMODIFIED, (Object)lastModified));
    }

    public int getId() {
        return this.getValue(Field.TICKETDATA_TICKETID, Integer.class);
    }

    public int getVersion() {
        return this.version;
    }

    public void addData(Field field, Object value) {
        this.data.add(new DataField(field, value));
    }

    public void setData(Field field, Object value) {
        for (DataField dataField : this.data) {
            if (dataField.getField() != field) continue;
            this.data.remove(dataField);
            break;
        }
        this.data.add(new DataField(field, value));
    }

    public void removeData(DataField dataField) {
        this.data.remove(dataField);
    }

    public void addData(DataField dataField) {
        this.data.add(dataField);
    }

    public ArrayList<DataField> getData() {
        return this.data;
    }

    public <T> T getValue(Field field, Class<T> dataClass) {
        for (DataField dField : this.data) {
            if (!field.equals((Object)dField.getField())) continue;
            return dField.getValue(dataClass);
        }
        return null;
    }

    public boolean isHtmlContent() {
        return this.htmlContent;
    }

    public void setHtmlContent(boolean htmlContent) {
        this.htmlContent = htmlContent;
    }
}

