/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config.stopwatch;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.config.LocalizedKeyListFactory;
import com.inet.helpdesk.config.stopwatch.ConditionType;
import com.inet.helpdesk.config.stopwatch.StopWatchCondition;
import com.inet.helpdesk.config.stopwatch.StopWatchList;
import com.inet.helpdesk.config.stopwatch.StopWatchRule;
import com.inet.helpdesk.config.stopwatch.StopWatchSetting;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.plugin.HelpdeskServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StopWatchConfig {
    public static List<LocalizedKey> getConditions() {
        return Arrays.stream(ConditionType.values()).map(ct -> new LocalizedKey(ct.name(), HelpdeskServerPlugin.MSG_CONFIG.getMsg("stopwatch.conditiontype." + ct.name(), new Object[0]))).collect(Collectors.toList());
    }

    public static List<LocalizedKey> getResourcesAndGroups() {
        List<LocalizedKey> userGroups = LocalizedKeyListFactory.getUserGroups(false, null);
        userGroups.add(0, new LocalizedKey("", ""));
        return userGroups;
    }

    public static List<LocalizedKey> getResources() {
        List<LocalizedKey> userGroups = LocalizedKeyListFactory.getUserGroups(false, HDUsersAndGroups.RESOURCE);
        userGroups.add(0, new LocalizedKey("", ""));
        return userGroups;
    }

    public static List<LocalizedKey> getSettings() {
        return Arrays.stream(StopWatchSetting.values()).map(ct -> new LocalizedKey(ct.name(), HelpdeskServerPlugin.MSG_CONFIG.getMsg("stopwatch.setting." + ct.name(), new Object[0]))).collect(Collectors.toList());
    }

    public static StopWatchList getStopWatchSettingsFromConfigGUI(List<Map<String, String>> rows) {
        StopWatchList list = new StopWatchList();
        for (Map<String, String> row : rows) {
            String conditionTypeRaw = row.get("ConditionType");
            if (conditionTypeRaw == null) {
                HDLogger.error("null value found in config rows -- ignoring...");
                continue;
            }
            ConditionType conditionType = ConditionType.valueOf(conditionTypeRaw);
            GUID parameter = conditionType == ConditionType.UserIsInGroup ? (StringFunctions.isEmpty((String)row.get("ConditionParameter")) ? null : GUID.valueOf((String)row.get("ConditionParameter"))) : (StringFunctions.isEmpty((String)row.get("ConditionParameterRess")) ? null : GUID.valueOf((String)row.get("ConditionParameterRess")));
            StopWatchRule setting = new StopWatchRule(new StopWatchCondition(conditionType, parameter), StopWatchSetting.valueOf(row.get("Setting")));
            list.add(setting);
        }
        return list;
    }
}

