/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.modules;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.modules.IPatcherModul;
import com.inet.dbupdater.modules.ModuleFactory;
import java.util.ArrayList;
import java.util.List;

public class ModulesRunner {
    private final ModuleFactory factory;
    private List<? extends IPatcherModul> list;
    private DatabaseInfos infos;

    public ModulesRunner(ModuleFactory factory) {
        this.factory = factory;
    }

    public Node run(Node model, DatabaseInfos infos) {
        this.infos = infos;
        this.list = this.factory.getModulsForDBMS(infos.getDBMSTypeName());
        if (this.list != null) {
            model = this.crawl(model);
        }
        return model;
    }

    private Node crawl(Node node) {
        Node result = node;
        for (IPatcherModul iPatcherModul : this.list) {
            if (result == null) continue;
            iPatcherModul.patchNode(result, this.infos);
        }
        if (result == null) {
            return null;
        }
        List<? extends Node> oldNodes = result.getAllChildren();
        if (oldNodes != null && oldNodes.size() > 0) {
            ArrayList<? extends Node> arrayList = new ArrayList<Node>(oldNodes);
            for (Node node2 : arrayList) {
                Node newChild = this.crawl(node2);
                if (newChild == null) {
                    result.removeChild(newChild);
                    continue;
                }
                if (newChild == node2) continue;
                result.replaceChild(node2, newChild);
            }
        }
        return result;
    }

    public void clean() {
        for (IPatcherModul iPatcherModul : this.list) {
            iPatcherModul.clean();
        }
    }
}

