/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.databases.IDatabaseInfos;
import com.inet.dbupdater.model.AttributeMap;
import com.inet.dbupdater.model.Diff;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.dbupdater.model.SimpleDTD;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ModelMerger {
    private NodeFactory factory = new NodeFactory();
    private boolean allowEntityMerge;

    public ModelMerger(boolean allowEntityMerge) {
        this.allowEntityMerge = allowEntityMerge;
    }

    public Node merge(Node first, Node ... toMerge) {
        if (toMerge == null || toMerge.length == 0) {
            return first;
        }
        Node merged = first = this.fillPath(first);
        for (Node newMerge : toMerge) {
            Node model = this.fillPath(newMerge);
            merged = this.mergeNode(merged, model);
        }
        return merged;
    }

    private Node mergeNode(Node node1, Node node2) {
        if (node1.getName() != node2.getName()) {
            throw new IllegalArgumentException("Missmatch in node type: " + String.valueOf((Object)node1.getName()) + " vs " + String.valueOf((Object)node2.getName()));
        }
        this.checkMergeValidity(node1, node2);
        Node copy = this.copy(node1, false);
        HashSet<? extends Node> children2 = new HashSet<Node>(node2.getAllChildren());
        block0: for (Node node : node1.getAllChildren()) {
            Comparator<Node> comparator = this.getNodeComparator(node.getName());
            for (Node node3 : children2) {
                int result = comparator.compare(node, node3);
                if (result != 0) continue;
                Node childCopy = this.mergeNode(node, node3);
                copy.addChild(childCopy);
                children2.remove(node3);
                continue block0;
            }
            copy.addChild(this.copy(node, true));
        }
        for (Node node : children2) {
            copy.addChild(this.copy(node, true));
        }
        return copy;
    }

    private void checkMergeValidity(Node node1, Node node2) {
        NodeFactory.TAG tag = node1.getName();
        if (this.allowEntityMerge) {
            switch (tag) {
                case column: 
                case index: 
                case reference: {
                    break;
                }
            }
        } else {
            switch (tag) {
                case function: 
                case table: 
                case procedure: 
                case trigger: {
                    Node diff = new Diff(node1, node2).run();
                    if (diff == null) break;
                    throw new IllegalStateException("Merge failed! The unique enitity '" + node1.getKeyValueOriginalCase() + "' of type " + tag.name().toUpperCase() + " is present in both models, but is different.");
                }
            }
        }
    }

    private Node copy(Node node, boolean deepCopy) {
        String content;
        Node copy = this.factory.createNode(node.getName().toString());
        AttributeMap<String> attributes = node.getAttributeMap();
        if (attributes != null) {
            for (Map.Entry e : attributes.entrySet()) {
                copy.readParameter(e.getKey().toString(), (String)e.getValue());
            }
        }
        if ((content = node.getContent()) != null) {
            copy.readString(content);
        }
        if (deepCopy) {
            for (Node node2 : node.getAllChildren()) {
                copy.addChild(this.copy(node2, true));
            }
        }
        return copy;
    }

    private Node fillPath(Node node) {
        while (node.getName() != NodeFactory.TAG.dbupdater) {
            Node parent = node.getParent();
            if (parent == null) {
                List<List<NodeFactory.TAG>> parentsList = SimpleDTD.getParents(node.getName());
                if (parentsList.size() > 1) {
                    throw new IllegalArgumentException("The merge structure is ambiguous since the element '" + String.valueOf((Object)node.getName()) + "' can appear in different contexts.");
                }
                List<NodeFactory.TAG> parents = parentsList.get(0);
                if (parents.size() == 0) {
                    return node;
                }
                NodeFactory.TAG parentName = parents.get(parents.size() - 1);
                Node parentNode = new NodeFactory().createNode(parentName.toString());
                parentNode.addChild(node);
                node = parentNode;
                continue;
            }
            node = parent;
        }
        return node;
    }

    private Comparator<Node> getNodeComparator(NodeFactory.TAG tag) {
        switch (tag) {
            case procedure: 
            case sql: 
            case modules: 
            case startvalue: 
            case condition: 
            case data: 
            case customscripts: {
                return new NodeWithContentComparator();
            }
            case version: {
                return new NodeVersionComparator();
            }
            case database: {
                return new NodeDatabaseComparator();
            }
        }
        return new NodeComparator();
    }

    private static class NodeWithContentComparator
    implements Comparator<Node> {
        private NodeWithContentComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getName() != o2.getName()) {
                return o1.getName().ordinal() - o2.getName().ordinal();
            }
            String content1 = o1.getContent();
            String content2 = o2.getContent();
            return content1 != null ? (content2 != null ? content1.trim().compareTo(content2.trim()) : -1) : (content2 != null ? 1 : 0);
        }
    }

    private static class NodeVersionComparator
    extends NodeWithContentComparator {
        private NodeVersionComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            List<? extends Node> c1list = o1.getChildren(NodeFactory.TAG.condition);
            List<? extends Node> c2list = o2.getChildren(NodeFactory.TAG.condition);
            if (c1list.size() != c2list.size()) {
                return c1list.size() - c2list.size();
            }
            if (c1list.size() != 1) {
                return -1;
            }
            Node condition1 = c1list.get(0);
            Node condition2 = c2list.get(0);
            return super.compare(condition1, condition2);
        }
    }

    private static class NodeDatabaseComparator
    implements Comparator<Node> {
        private NodeDatabaseComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getName() != o2.getName()) {
                return o1.getName().ordinal() - o2.getName().ordinal();
            }
            String dbms1 = o1.getParameter(IDatabaseInfos.DATABASE_PARAM.productname.name());
            String dbms2 = o2.getParameter(IDatabaseInfos.DATABASE_PARAM.productname.name());
            int type1 = DatabaseInfoFactory.getDatabaseType(dbms1);
            int type2 = DatabaseInfoFactory.getDatabaseType(dbms2);
            return type1 - type2;
        }
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1.getName() != o2.getName()) {
                return o1.getName().ordinal() - o2.getName().ordinal();
            }
            String[] keys = o1.getKeyParamNames();
            if (keys != null) {
                for (String key : keys) {
                    String value1 = o1.getParameter(key);
                    String value2 = o2.getParameter(key);
                    if (value1 == null || value2 == null) {
                        if (value1 == null && value2 == null) continue;
                        return value1 == null ? -1 : 1;
                    }
                    int result = value1.toLowerCase().compareTo(value2.toLowerCase());
                    if (result == 0) continue;
                    return result;
                }
            }
            return 0;
        }
    }
}

