/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.jobrunner.jobs;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.jobrunner.JobStructure;
import com.inet.dbupdater.jobrunner.jobs.IJob;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;
import java.util.List;

public class JobCreateProcedure
implements IJob {
    private final int state_new;

    public JobCreateProcedure(int state_new) {
        this.state_new = state_new;
    }

    @Override
    public JobStructure createCommands(DatabaseInfos targetCon, Node model) {
        if (model.getName() != NodeFactory.TAG.procedure) {
            throw new IllegalArgumentException("The JobCreateProcedure can be used only for procedures!");
        }
        JobStructure commands = new JobStructure();
        String name = model.getParameter(model.getKeyParamNames()[0]);
        if (name == null) {
            return null;
        }
        ICommandFactory.COMMAND_TYPE command_type = this.state_new == 0 ? ICommandFactory.COMMAND_TYPE.create : ICommandFactory.COMMAND_TYPE.alter;
        IComposedCommand command = targetCon.getCommandFactory().getCommand(command_type, NodeFactory.TAG.procedure, null, model, null);
        try {
            List<IComposedCommand> composedCommand = command.addDataset(model, command_type);
            commands.add(command);
            commands.addCommands(composedCommand);
        }
        catch (SQLException e) {
            Logger logger = LogManager.getLogger((String)"DB Updater");
            logger.error((Object)"Job create / alter procedure failed");
            logger.error((Throwable)e);
            return null;
        }
        return commands;
    }
}

