/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.databases.commands;

import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.databases.commands.ICommandFactory;
import com.inet.dbupdater.databases.commands.IComposedCommand;
import com.inet.dbupdater.databases.commands.IDatabaseCommand;
import com.inet.dbupdater.model.Node;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.sql.SQLException;
import java.util.List;

public class DefaultSimpleCommand
implements IComposedCommand {
    private String command;
    private DatabaseInfos dbInfo;
    private boolean isUpdate;
    private IDatabaseCommand.TIME execTime;
    private static Logger logger = LogManager.getLogger((String)"DB Updater");
    private final boolean mayFail;
    private String commandKey;

    protected DefaultSimpleCommand(String command, DatabaseInfos dbInfo, boolean isUpdate, IDatabaseCommand.TIME execTime, boolean mayFail) {
        this(command, dbInfo, isUpdate, execTime, mayFail, command);
    }

    protected DefaultSimpleCommand(String command, DatabaseInfos dbInfo, boolean isUpdate, IDatabaseCommand.TIME execTime, boolean mayFail, String commandKey) {
        this.command = command;
        this.dbInfo = dbInfo;
        this.isUpdate = isUpdate;
        this.execTime = execTime;
        this.mayFail = mayFail;
        this.commandKey = commandKey;
    }

    @Override
    public boolean accepts(Node element, ICommandFactory.COMMAND_TYPE action) {
        return false;
    }

    @Override
    public List<IComposedCommand> addDataset(Node element, ICommandFactory.COMMAND_TYPE action) throws SQLException {
        return null;
    }

    @Override
    public String getCommandKey() {
        return this.commandKey;
    }

    @Override
    public int execute() throws SQLException {
        try {
            int success = 0;
            success = this.isUpdate ? this.dbInfo.getDBConnection().executeUpdate(this.command) : (this.dbInfo.getDBConnection().execute(this.command) ? 1 : -1);
            return success;
        }
        catch (SQLException e) {
            if (!this.mayFail) {
                throw e;
            }
            logger.warn((Object)("Statement failed: " + this.command));
            return 1;
        }
    }

    @Override
    public IDatabaseCommand.TIME getEvaluationTime() {
        return this.execTime;
    }

    @Override
    public String getSqlStatement() {
        return this.command;
    }
}

