/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater;

import com.inet.dbupdater.UpdaterEvent;
import com.inet.dbupdater.UpdaterEventDispatcher;
import com.inet.dbupdater.UpdaterListener;
import com.inet.dbupdater.databases.DBReader;
import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.databases.DatabaseInfos;
import com.inet.dbupdater.dbconnection.DBConnection;
import com.inet.dbupdater.model.Constructor;
import com.inet.dbupdater.model.ModelWriterXML;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.SuppressFBWarnings;

public class DBScanner {
    private final UpdaterEventDispatcher dispatcher;
    private static Logger LOGGER = LogManager.getLogger((String)"DB Updater");

    public DBScanner() {
        this.dispatcher = null;
    }

    public DBScanner(UpdaterEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Node scanStructur(DBConnection dbcon) throws SQLException {
        return this.scanStructur(dbcon, null);
    }

    public Node scanStructur(DBConnection dbcon, DatabaseInfos dbinfo) throws SQLException {
        if (dbcon.getConnection() == null) {
            dbcon.openConnection(dbinfo);
        }
        if (dbinfo == null) {
            try {
                dbinfo = DatabaseInfoFactory.getDatabaseInfos(DatabaseInfoFactory.getDatabaseType(dbcon.getConnection()), dbcon);
            }
            catch (SQLException e) {
                LOGGER.error((Throwable)e);
                dbinfo = new DatabaseInfos(dbcon);
            }
            if (dbcon.getConnection() != null && dbcon.getDatabaseName() != null) {
                try {
                    dbinfo.activateDatabase(dbcon, dbcon.getConnection(), dbcon.getDatabaseName());
                }
                catch (SQLException e) {
                    return null;
                }
            }
        }
        Constructor constructor = new Constructor(new NodeFactory());
        constructor.startElement(NodeFactory.TAG.database.name());
        DBConnection dbCon = dbinfo.getDBConnection();
        Connection connection = dbCon.getConnection();
        if (connection == null) {
            throw new SQLException("Database connection not available.");
        }
        constructor.setParameterToCurrentElement("productname", connection.getMetaData().getDatabaseProductName());
        String catalog = null;
        String databaseName = null;
        try {
            databaseName = dbCon.getDatabaseName();
            if (databaseName != null) {
                dbinfo.activateDatabase(dbCon, dbCon.getConnection(), databaseName);
                catalog = dbCon.getConnection().getCatalog();
                if (catalog == null || catalog.length() == 0) {
                    catalog = databaseName;
                }
            } else {
                databaseName = catalog = dbinfo.getCurrentSchema();
                dbCon.setDatabaseName(databaseName);
            }
        }
        catch (SQLException e) {
            LOGGER.info((Object)("Database " + databaseName + " not found."));
            LOGGER.info((Object)e);
        }
        if (catalog == null || !catalog.equalsIgnoreCase(databaseName)) {
            LOGGER.error((Object)("Catalog should be '" + databaseName + "' but was '" + catalog + "'"));
            return null;
        }
        if (this.dispatcher != null) {
            this.dispatcher.setJobCount(this.dispatcher.getJobCount() + 4);
        }
        DBReader reader = new DBReader(dbinfo, constructor);
        if (this.dispatcher != null) {
            this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "scanningTablesAndViews", new Object[0]));
        }
        reader.readTablesAndViews();
        if (this.dispatcher != null) {
            this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "scanningProceduresAndFunctions", new Object[0]));
        }
        reader.readProceduresAndFunction();
        if (this.dispatcher != null) {
            this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "scanningTriggers", new Object[0]));
        }
        reader.readTriggers();
        if (this.dispatcher != null) {
            this.dispatcher.notifyListeners(new UpdaterEvent(this.dispatcher.getCurrentJob() + 1, "scanningSequences", new Object[0]));
        }
        reader.readSequences();
        constructor.endCurrentElement(NodeFactory.TAG.database.name());
        dbcon.closeConnection();
        Node result = constructor.getRoot();
        dbinfo.getModelPatcher().patchModel(result);
        return result;
    }

    public Node scanDatasets(DBConnection dbcon, String elementname) {
        return this.scanDatasets(dbcon, elementname, null);
    }

    public Node scanDatasets(DBConnection dbcon, String elementname, DatabaseInfos dbinfo) {
        if (dbcon.getConnection() == null) {
            dbcon.openConnection(dbinfo);
        }
        if (dbinfo == null) {
            try {
                dbinfo = DatabaseInfoFactory.getDatabaseInfos(DatabaseInfoFactory.getDatabaseType(dbcon.getConnection()), dbcon);
            }
            catch (SQLException e) {
                LOGGER.error((Throwable)e);
                dbinfo = new DatabaseInfos(dbcon);
            }
            if (dbcon.getConnection() != null) {
                if (dbcon.getDatabaseName() != null) {
                    try {
                        dbinfo.activateDatabase(dbcon, dbcon.getConnection(), dbcon.getDatabaseName());
                    }
                    catch (SQLException e) {
                        return null;
                    }
                }
                try {
                    dbinfo.getDBConnection().setDatabaseName(dbinfo.getCurrentSchema());
                }
                catch (SQLException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }
        Constructor constructor = new Constructor(new NodeFactory());
        constructor.startElement(NodeFactory.TAG.data.name());
        DBReader reader = new DBReader(dbinfo, constructor);
        reader.readDatasets(elementname);
        constructor.endCurrentElement(NodeFactory.TAG.data.name());
        dbcon.closeConnection();
        return constructor.getRoot();
    }

    private void createXmlFileFromNodes(File xmltarget, Node[] nodes) {
        Constructor constructor = new Constructor(new NodeFactory());
        constructor.startElement(NodeFactory.TAG.dbupdater.name());
        for (Node child : nodes) {
            constructor.getRoot().addChild(child);
        }
        constructor.endCurrentElement(NodeFactory.TAG.dbupdater.name());
        try {
            PrintWriter pw = new PrintWriter(xmltarget, "UTF8");
            new ModelWriterXML(pw, constructor.getRoot()).run();
            pw.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private static String scanArgs(String key, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!key.equalsIgnoreCase(args[i]) || i >= args.length - 1) continue;
            return args[i + 1];
        }
        return null;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="user specifies file is expected")
    public static void main(String[] args) throws SQLException {
        Object filename;
        UpdaterEventDispatcher dispatcher = new UpdaterEventDispatcher();
        dispatcher.addUpdaterListener(new UpdaterListener(){

            @Override
            public void notifyDbUpdate(UpdaterEvent updateEvent) {
            }
        });
        if (args.length == 0) {
            LOGGER.fatal((Object)"Parameters:\n-url       Connection URL\n-user      User name\n-password  Password\n-database  Database to read\n-drv       Driver class to use (optional)\n-file      File to write to (optional, default = <database>.xml)");
            return;
        }
        String url = DBScanner.scanArgs("-url", args);
        if (url == null) {
            LOGGER.fatal((Object)"Please set a connection url by the parameter '-url'");
            return;
        }
        String user = DBScanner.scanArgs("-user", args);
        if (user == null) {
            LOGGER.fatal((Object)"Please set a user by the parameter '-user'");
            return;
        }
        String password = DBScanner.scanArgs("-password", args);
        if (password == null) {
            LOGGER.fatal((Object)"Please set a password by the parameter '-password'");
            return;
        }
        String database = DBScanner.scanArgs("-database", args);
        if (database == null) {
            LOGGER.fatal((Object)"Please set a database by the parameter '-database'");
            return;
        }
        String driver = DBScanner.scanArgs("-drv", args);
        if (driver == null) {
            if (url.contains("jdbc:mysql")) {
                driver = "com.mysql.cj.jdbc.Driver";
            } else if (url.contains("jdbc:inetdae7")) {
                driver = "com.inet.tds.TdsDriver";
            } else if (url.contains("jdbc:inetora")) {
                driver = "com.inet.ora.OraDriver";
            } else {
                LOGGER.fatal((Object)"Please set as driver by parameter 'drv' since the driver cannot be derived from the connection URL.");
            }
        }
        if ((filename = DBScanner.scanArgs("-file", args)) == null) {
            filename = database + ".xml";
        }
        DBConnection dbcon = new DBConnection();
        dbcon.setJdbcDriverClass(driver);
        dbcon.setJdbcUser(user);
        dbcon.setJdbcPassword(password);
        dbcon.setJdbcUrl(url);
        dbcon.setDatabaseName(database);
        DBScanner scanner = new DBScanner(dispatcher);
        Node mysqlroot = new DBScanner(dispatcher).scanStructur(dbcon);
        scanner.createXmlFileFromNodes(new File(database + ".xml"), new Node[]{mysqlroot});
    }
}

