/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.field.SelectOption;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeSelect_Int;
import com.inet.field.fieldtypes.HasSelectOptions;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.usersandgroups.user.fields.HDUserField;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class FieldLocationID
extends HDUserField<Integer>
implements HasSelectOptions {
    public static final String KEY = "location";

    public FieldLocationID() {
        super(KEY, 0, FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldTypeSelect_Int createFieldType() {
        return new FieldTypeSelect_Int(KEY, () -> this.getLabel(), this){

            public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(FieldLocationID.KEY, SearchDataType.IntegerMap, false, 900, labelProvider){

                    public Map<Integer, String> getMapData() {
                        return LocationManager.getInstance().getAll(false).stream().filter(vo -> vo.getDisplayValue() != null).collect(Collectors.toMap(c -> c.getId(), FieldVO::getDisplayValue));
                    }
                });
            }
        };
    }

    public void setDefaultValue(@Nonnull Integer value) {
        this.validate(value);
        super.setDefaultValue((Object)value);
    }

    public void validate(Integer value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfNegative((int)value);
    }

    public List<SelectOption> getSelectOptions(boolean includeDeleted) {
        List allLocations = LocationManager.getInstance().getAll(!includeDeleted);
        return allLocations.stream().map(c -> new SelectOption("" + c.getId(), c.getDisplayValue())).collect(Collectors.toList());
    }
}

