/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.field.fieldtypes.FieldTypeString;
import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.usersandgroups.user.fields.HDUserField;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class FieldImportName
extends HDUserField<String> {
    public static final String KEY = "importname";

    public FieldImportName() {
        super(KEY, "", FieldTypeFactory.custom());
    }

    @Nonnull
    public FieldType<String> createFieldType() {
        return new FieldTypeString(this.getKey(), () -> this.getLabel()){

            public SearchTag createSearchTag(Supplier<String> displayname, @Nonnull FieldTypeFactory fieldTypeFactory) {
                return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.StringMap, true, (SearchTokenizer)new GuidTokenizer(), 0, displayname, true){

                    @Nonnull
                    public Map<? extends Comparable<?>, String> getMapData() {
                        DataImportConnector cn = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
                        UserImportConfigInfoMap imports = cn.getUserImports();
                        HashMap<String, String> result = new HashMap<String, String>();
                        for (UserImportConfigInfo info : imports.values()) {
                            result.put(info.getUid(), info.getName());
                        }
                        return result;
                    }

                    public boolean showAlsoNonMapValues() {
                        return true;
                    }
                });
            }
        };
    }

    public String getValidOrDefaultValue(String value, GUID entryID) {
        if (value == null) {
            return "";
        }
        return (String)super.getValidOrDefaultValue((Object)value, entryID);
    }

    public void validate(String value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)50);
    }
}

