/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups.persistence;

import com.inet.annotations.JsonData;
import com.inet.error.PersistenceException;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

@JsonData
public class HelpDeskUserGroupDetails {
    public static final String PROPERTY_PERMISSIONS = "permissions";
    private HashMap<String, String> properties;
    private HashMap<String, String> fields;

    private HelpDeskUserGroupDetails() {
    }

    public static String toJsonizedDetails(MutableUserGroupData groupData, Set<String> permissions) {
        try {
            Set includedFields = groupData.getIncludedFields();
            HashMap<String, String> jsonizedValues = new HashMap<String, String>(includedFields.size());
            for (UserGroupField field : includedFields) {
                Object value = groupData.get(field);
                String jsonData = value == null ? null : new Json().toJson(value);
                jsonizedValues.put(field.getKey(), jsonData);
            }
            HelpDeskUserGroupDetails details = new HelpDeskUserGroupDetails(jsonizedValues, permissions);
            return new Json().toJson((Object)details);
        }
        catch (JsonException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public HelpDeskUserGroupDetails(HashMap<String, String> fields, Set<String> permissions) {
        this.properties = new HashMap();
        if (permissions == null) {
            permissions = new HashSet<String>();
        }
        this.properties.put(PROPERTY_PERMISSIONS, new Json().toJson(permissions));
        this.fields = fields;
    }

    public HashMap<String, String> getFields() {
        return this.fields == null ? new HashMap<String, String>() : this.fields;
    }

    public Set<String> getPermissions() {
        try {
            String value = this.getProperty(PROPERTY_PERMISSIONS);
            return (Set)new Json().fromJson(value, (Type)new JsonParameterizedType(Set.class, new Type[]{String.class}));
        }
        catch (JsonException ex) {
            return new HashSet<String>();
        }
    }

    private String getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }
}

