/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.groups.fields;

import com.inet.field.Field;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.search.tokenizers.EmailAddressTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.ui.fields.EmailAddressHelper;
import javax.annotation.Nullable;

public class ResourceFieldEmail
extends UserGroupField<String> {
    public static final String KEY = "resourceemail";
    private static final int VALUE_LENGTH_LIMIT = 250;

    public ResourceFieldEmail() {
        super(KEY, (Object)"", FieldTypeFactory.auto().withTokenizer((SearchTokenizer)new EmailAddressTokenizer()).withSearchPrio(150));
    }

    public String getValidOrDefaultValue(String value, @Nullable GUID entryID) {
        return EmailAddressHelper.get().getValidOrDefaultValue((Field)this, value, 250, entryID);
    }

    public void validate(String value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfLengthExceedsLimit((String)value, (int)250);
        EmailAddressHelper.get().throwIfContainsInvalidEmailAddresses(value);
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getStaticDisplayNameForUserField(KEY);
    }
}

