/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.CustomTicketViewDefinition;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.ticketview.TicketViewTree;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.command.SearchCommand;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class CustomTicketViewFactory
implements TicketViewFactory {
    private final CustomTicketViewDefinition viewDef;
    private final TicketViewTree tree;
    private SubViewGroupingDefinition subViewGrouping;

    CustomTicketViewFactory(@Nonnull CustomTicketViewDefinition viewDef, @Nonnull TicketViewTree tree) {
        this.viewDef = viewDef;
        this.tree = tree;
        String subViewGroupingKey = viewDef.getSubViewGroupingKey();
        if (subViewGroupingKey != null) {
            try {
                SubViewGroupingDefinition groupDef = (SubViewGroupingDefinition)DynamicExtensionManager.getInstance().getSingleInstanceByName(SubViewGroupingDefinition.class, subViewGroupingKey, false);
                TicketFieldDefinition definition = Tickets.getFieldDefinitionByKey(groupDef.getRelatedFieldKey());
                if (definition != null && definition.isAvailable() || "supervisor".equals(subViewGroupingKey) && !UserClassManager.getInstance().getTeamsWhereUserIsSupervisor(UserManager.getInstance().getCurrentUserAccountID()).isEmpty()) {
                    this.subViewGrouping = groupDef;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    @Nonnull
    public String getID() {
        return this.viewDef.getID();
    }

    @Override
    public String getDisplayName() {
        return this.viewDef.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.viewDef.getDescription();
    }

    @Override
    @Nonnull
    public String getCategoryKey() {
        if (this.subViewGrouping != null || this.viewDef.getSubViewGroupingKey() != null) {
            return this.viewDef.getDisplayName();
        }
        return this.viewDef.getCategoryKey();
    }

    @Override
    @Nullable
    public SearchCommand createSearchCommand(@Nonnull GUID accountID, @Nonnull Locale locale, @Nonnull IndexSearchEngine<Integer> engine) {
        try {
            SearchCommand parentCommand;
            SearchCommand command;
            try (UserAccountScope scape = UserAccountScope.create((GUID)accountID);){
                Locale oldLocale = ClientLocale.getThreadLocale();
                ClientLocale.setThreadLocale((Locale)locale);
                command = this.viewDef.createSearchCommand();
                ClientLocale.setThreadLocale((Locale)oldLocale);
            }
            String parentId = this.viewDef.getParentID();
            TicketViewSearchCommandFactory parentFactory = parentId != null ? this.tree.getTicketViewSearchFactory(parentId) : GlobalSearchViewDefinition.INSTANCE;
            if (parentFactory == null) {
                return null;
            }
            try {
                parentCommand = parentFactory.createSearchCommand(accountID, locale, engine);
                if (parentCommand == null) {
                    return null;
                }
            }
            catch (Throwable th) {
                HDLogger.error(th);
                parentCommand = GlobalSearchViewDefinition.INSTANCE.createSearchCommand(accountID, locale, engine);
            }
            command.getSearchExpression().addAll(0, (Collection)parentCommand.getSearchExpression());
            if (this.subViewGrouping != null) {
                this.subViewGrouping.appendMarker(command);
            }
            return command;
        }
        catch (Throwable th) {
            HDLogger.error(th);
            return null;
        }
    }

    @Override
    public SubViewGroupingDefinition getSubViewGrouping() {
        return this.subViewGrouping;
    }

    @Override
    public boolean isTokenizeGroupingValues() {
        return this.viewDef.isTokenizeGroupingValues();
    }

    @Override
    public boolean isHideSubnodeTickets() {
        return this.viewDef.isHideSubnodeTickets();
    }

    @Nonnull
    public CustomTicketViewDefinition getCustomView() {
        return this.viewDef;
    }
}

