/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.extensions;

import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.ticketmanager.TicketManipulatorInternal;
import com.inet.helpdesk.ticketmanager.model.OperationChangedTicketImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class UnbundleTicketActionExtensionFactory
implements TicketActionExtensionFactory {
    public static final ExtensionArguments.ExtArg<UnbundleTicketActionExtensionData> EXTARG_UNBUNDLE_TICKETS = new ExtensionArguments.ExtArg<UnbundleTicketActionExtensionData>(){

        @Override
        public String getKey() {
            return "ticketactionextension.unbundle";
        }

        @Override
        public Class<UnbundleTicketActionExtensionData> getValueType() {
            return UnbundleTicketActionExtensionData.class;
        }

        @Override
        public String toJson(UnbundleTicketActionExtensionData value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnbundleTicketActionExtensionData fromJson(String jsonData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnbundleTicketActionExtensionData copyValue(UnbundleTicketActionExtensionData value) {
            return value.copy();
        }
    };

    @Override
    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepData) {
        UnbundleTicketActionExtensionData extData = arguments.get(EXTARG_UNBUNDLE_TICKETS);
        if (extData instanceof UnbundleTicketActionExtensionData) {
            return new UnbundleTicketActionExtension(extData);
        }
        return null;
    }

    public static class UnbundleTicketActionExtensionData {
        private final List<Integer> idsOfTicketsToUnbundle;
        private final boolean updateLastEditor;

        public UnbundleTicketActionExtensionData(List<Integer> idsOfTicketsToUnbundle, boolean updateLastEditor) {
            this.idsOfTicketsToUnbundle = Collections.unmodifiableList(new ArrayList<Integer>(idsOfTicketsToUnbundle));
            this.updateLastEditor = updateLastEditor;
        }

        public List<Integer> getIDsOfTicketsToUnbundle() {
            return this.idsOfTicketsToUnbundle;
        }

        public boolean shouldUpdateLastEditor() {
            return this.updateLastEditor;
        }

        public UnbundleTicketActionExtensionData copy() {
            return new UnbundleTicketActionExtensionData(this.idsOfTicketsToUnbundle, this.updateLastEditor);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.idsOfTicketsToUnbundle == null ? 0 : this.idsOfTicketsToUnbundle.hashCode());
            result = 31 * result + (this.updateLastEditor ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnbundleTicketActionExtensionData other = (UnbundleTicketActionExtensionData)obj;
            if (this.idsOfTicketsToUnbundle == null ? other.idsOfTicketsToUnbundle != null : !this.idsOfTicketsToUnbundle.equals(other.idsOfTicketsToUnbundle)) {
                return false;
            }
            return this.updateLastEditor == other.updateLastEditor;
        }
    }

    private static class UnbundleTicketActionExtension
    implements TicketActionExtension {
        private final List<Integer> idsOfTicketsToUnbundle;
        private final boolean updateLastEditor;

        public UnbundleTicketActionExtension(UnbundleTicketActionExtensionData extData) {
            this.idsOfTicketsToUnbundle = extData.getIDsOfTicketsToUnbundle();
            this.updateLastEditor = extData.shouldUpdateLastEditor();
        }

        @Override
        public void extendTicketAction(ActionVO action, OperationChangedTicket masterTicket, OperationNewReaStep reaStep, TicketSubOperations operations) {
            long lastModified = System.currentTimeMillis();
            ProcessingTime processingTime = ProcessingTime.of(lastModified);
            reaStep.getFields().put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
            String commaSeparatedTicketIDs = this.idsOfTicketsToUnbundle.stream().sorted().map(val -> val.toString()).collect(Collectors.joining(", "));
            Object desc = Tickets.MSG.getMsg(Tickets.serverLocale(), "action.unbundle.master", new Object[]{commaSeparatedTicketIDs});
            if (((String)desc).length() > 255) {
                String dots = "...";
                desc = ((String)desc).substring(0, 255 - dots.length()) + dots;
            }
            reaStep.getFields().put(ReaStepVO.FIELD_DESC, desc);
            MutableReaStepData ticketToUnbundleStepData = new MutableReaStepData();
            ticketToUnbundleStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
            ticketToUnbundleStepData.put(ReaStepVO.FIELD_DESC, Tickets.MSG.getMsg(Tickets.serverLocale(), "action.unbundle.slave", new Object[]{masterTicket.getOldTicket().get().getID()}));
            this.unbundleTickets(masterTicket, lastModified, ticketToUnbundleStepData);
        }

        private void unbundleTickets(OperationChangedTicket masterTicket, long lastModified, MutableReaStepData ticketToUnbundleStepData) {
            TicketManipulatorInternal.TicketInnerOperationsImpl ticketInnerOperationsImpl = (TicketManipulatorInternal.TicketInnerOperationsImpl)TicketManager.extending().getTicketInnerOperations();
            for (int slaveId : this.idsOfTicketsToUnbundle) {
                OperationChangedTicket slaveTicket = masterTicket.getParentModel().changeExistingTicket(slaveId);
                slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_BUNDLE_ID, null);
                if (this.updateLastEditor) {
                    slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_EDITOR_GUID, TicketManipulatorInternal.getCurrentUserAccountOrThrowISE().getID());
                }
                slaveTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, lastModified);
                for (ReaStepVO step : TicketManager.extending().getTicketInnerOperations().getReaStepsForTicket(slaveId, BundleStepsFilter.WITH_BUNDLE_STEPS)) {
                    if (step.getBunID() == slaveId) continue;
                    ((OperationChangedTicketImpl)slaveTicket).changeReaStep(step.getID(), slaveId);
                    masterTicket.changeReaStep(step.getID());
                }
                masterTicket.getAfterWriteOperations().add(() -> ticketInnerOperationsImpl.clearCachedBundleTickets(slaveId));
                slaveTicket.addReaStep(-13, ticketToUnbundleStepData, MutableReaStepText.empty());
                this.updateTicketSumTime(slaveTicket, Collections.emptyList());
            }
            masterTicket.getAfterWriteOperations().add(() -> ticketInnerOperationsImpl.clearCachedBundleTickets(masterTicket.getTicketId()));
            this.updateTicketSumTime(masterTicket, this.idsOfTicketsToUnbundle);
            masterTicket.getAfterWriteOperations().add(() -> ticketInnerOperationsImpl.updateAttachmentFlagForTicket(masterTicket.getTicketId()));
            if (TicketManager.getReader().getTicketsInBundle(masterTicket.getOldTicket().get().getID(), false).size() == this.idsOfTicketsToUnbundle.size()) {
                masterTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_BUNDLE_ID, null);
                masterTicket.getAfterWriteOperations().add(() -> ticketInnerOperationsImpl.onUnbundleClearBundleVisibleForTicket(masterTicket.getOldTicket().get().getID()));
            }
        }

        private void updateTicketSumTime(OperationChangedTicket ticketToUpdate, List<Integer> ticketsToIgnoreInCalculation) {
            AtomicLong summe = new AtomicLong();
            TicketManager.extending().getTicketInnerOperations().getReaStepsForTicket(ticketToUpdate.getTicketId(), BundleStepsFilter.WITH_BUNDLE_STEPS).forEach(ticketStep -> {
                if (!ticketsToIgnoreInCalculation.contains(ticketStep.getOrgBunID()) && ticketStep.getStartDate() > 0L && ticketStep.getEndDate() > 0L) {
                    summe.addAndGet((ticketStep.getEndDate() - ticketStep.getStartDate()) / 60000L);
                }
            });
            ticketToUpdate.getNewTicketAttributes().put(Tickets.ATTRIBUTE_SUM_TIME, summe.intValue());
        }
    }
}

