/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.search;

import com.inet.helpdesk.core.HDLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import javax.annotation.SuppressFBWarnings;

public class SqlQueryThread
extends Thread {
    private String query = "";
    private Statement queryStatement;
    private ResultSet results;
    private LinkedHashSet<String> resultids = new LinkedHashSet();
    private boolean returnResultset = true;
    private SQLException error;

    public SqlQueryThread(String query, Connection con, boolean resultset) throws SQLException {
        this.query = query;
        this.returnResultset = resultset;
        this.queryStatement = con.createStatement();
        this.queryStatement.setQueryTimeout(30);
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="Internal Searcher API")
    public void run() {
        try {
            if (this.returnResultset) {
                this.results = this.queryStatement.executeQuery(this.query);
                while (this.results.next()) {
                    this.resultids.add(this.results.getString("BunID"));
                }
            } else {
                this.queryStatement.execute(this.query);
            }
        }
        catch (SQLException e) {
            HDLogger.debug(this.query);
            this.error = e;
            HDLogger.error(e);
        }
        finally {
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this.queryStatement != null) {
                try {
                    this.queryStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    LinkedHashSet<String> getBunIDs() {
        return this.resultids;
    }

    boolean wasError() {
        return this.error != null;
    }

    SQLException getError() {
        return this.error;
    }
}

