/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.userfilter;

import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TicketDataConnector;
import com.inet.helpdesk.core.model.ticket.Ticket;
import com.inet.helpdesk.data.userfilter.UserFilter;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TicketRecipientFilter
implements UserFilter {
    private Set<Integer> receivers = new HashSet<Integer>();

    public TicketRecipientFilter(String ticketIDString) throws ServerDataException {
        try {
            TicketDataConnector connector = (TicketDataConnector)ServerPluginManager.getInstance().getSingleInstance(TicketDataConnector.class);
            int ticketID = Integer.parseInt(ticketIDString);
            Ticket ticket = connector.getTicket(ContextType.supporter, ticketID, TicketDataConnector.TicketText.NONE);
            if (ticket == null) {
                return;
            }
            ArrayList<User> users = connector.getReceivers(ticket, TicketDataConnector.RECEIVERTYP.ALL, true);
            for (User user : users) {
                Integer userID = user.getValue(Field.USERDATA_USERID, Integer.class);
                if (userID == null) continue;
                this.receivers.add(userID);
            }
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    @Override
    public int score(UserAccount userAccount) {
        int userID = HDUsersAndGroups.getUserID(userAccount);
        return this.receivers.contains(userID) ? 1 : 0;
    }
}

