/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.core.ticketview;

import com.inet.annotations.JsonData;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.search.SearchTagBundleSlave;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewDefinition;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.html.utils.Base64;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class CustomTicketViewDefinition
implements TicketViewDefinition {
    public static final String GLOBAL_RECENTLY_CHANGED = "lastchanged:7d";
    public static final String GLOBAL_TERMIN = "terminvereinbarungdate:>1d";
    public static final String GLOBAL_REMINDER = "statusid:\"150\"";
    public static final String GLOBAL_UNTOUCHED = "opentickets|lastchanged:<1m";
    public static final String GLOBAL_OLD = "opentickets|inquirydate:<1m";
    private static final String GLOBAL_CLOSED_BASE = "statusid:>=\"300\" closeddate:";
    public static final String GLOBAL_CLOSED_14 = "statusid:>=\"300\" closeddate:14d";
    public static final String GLOBAL_BUNDELD = "opentickets|tickettags:\"0\"";
    public static final String GLOBAL_DEADLINE = "opentickets|tickettags:\"2\"";
    public static final String GLOBAL_ESCALATED = "opentickets|tickettags:\"3\"";
    public static final String GLOBAL_EXPANSIV = "opentickets|sumtime:>300";
    private String id;
    private String parentId;
    private String displayName;
    private String description;
    private String phrase;
    private String subViewGroupingKey;
    private boolean tokenizeGroupingValues;
    private boolean hideSubnodeTickets;
    private List<String> userGroups;
    private byte[] icondata;
    private String locale;
    private GUID originalCreator = null;
    public static final ConfigValue<Integer> ENDUSDER_FROM_TICKET_NUM = new ConfigValue(HDConfigKeys.ENDUSER_ONLY_SHOW_FROM_TICKET_NUMBER);

    private CustomTicketViewDefinition() {
    }

    public CustomTicketViewDefinition(@Nonnull String id, @Nullable String parentId, @Nullable String displayName, @Nullable String description, String phrase, String subViewGroupingKey, boolean tokenizeGroupingValues, boolean hideSubnodeTickets, @Nullable List<String> userGroups, byte[] icondata, GUID originalCreator) {
        Objects.requireNonNull(id);
        this.id = id;
        this.parentId = parentId;
        this.displayName = displayName;
        this.description = description;
        this.phrase = phrase;
        this.subViewGroupingKey = subViewGroupingKey;
        this.tokenizeGroupingValues = tokenizeGroupingValues;
        this.hideSubnodeTickets = hideSubnodeTickets;
        this.userGroups = userGroups;
        this.icondata = icondata;
        this.locale = ClientLocale.getThreadLocale().toString();
        this.originalCreator = originalCreator;
        try {
            IndexSearchEngine<Integer> searchEngine = TicketManager.getReaderForSystem().getSearchEngine();
            AndSearchExpression originalSearch = new TextSearchCommandBuilder(searchEngine, phrase).build().getSearchExpression();
            StringBuilder phraseBuilder = new StringBuilder();
            originalSearch.toPhrase(phraseBuilder, searchEngine, true);
            String genericPhrase = phraseBuilder.toString();
            AndSearchExpression genericSearch = new TextSearchCommandBuilder(searchEngine, genericPhrase).buildWithGenericLocale().getSearchExpression();
            if (originalSearch.equals((Object)genericSearch)) {
                this.locale = null;
                this.phrase = genericPhrase;
            }
        }
        catch (Throwable th) {
            LogManager.getApplicationLogger().debug((Object)th);
        }
    }

    @Nonnull
    public static CustomTicketViewDefinition createGlobalView(@Nonnull String generalizePhrase, SubViewGroupingDefinition group, @Nonnull List<GUID> userGroupIDs) {
        return CustomTicketViewDefinition.createGlobalView(generalizePhrase, group, userGroupIDs, null);
    }

    @Nonnull
    public static CustomTicketViewDefinition createGlobalView(@Nonnull String generalizePhrase, SubViewGroupingDefinition group, @Nonnull List<GUID> userGroupIDs, String viewID) {
        return CustomTicketViewDefinition.createGlobalView(generalizePhrase, group, userGroupIDs, viewID, null);
    }

    @Nonnull
    public static CustomTicketViewDefinition createGlobalView(@Nonnull String generalizePhrase, SubViewGroupingDefinition group, @Nonnull List<GUID> userGroupIDs, String viewID, String name) {
        return CustomTicketViewDefinition.createGlobalView(generalizePhrase, group, userGroupIDs, viewID, name, null);
    }

    @Nonnull
    public static CustomTicketViewDefinition createGlobalView(@Nonnull String generalizePhrase, SubViewGroupingDefinition group, @Nonnull List<GUID> userGroupIDs, String viewID, String name, String description) {
        CustomTicketViewDefinition view = new CustomTicketViewDefinition();
        int idx = generalizePhrase.indexOf(124);
        if (idx > 0) {
            view.parentId = generalizePhrase.substring(0, idx);
            generalizePhrase = generalizePhrase.substring(idx + 1);
        }
        view.phrase = generalizePhrase;
        if (group != null) {
            view.subViewGroupingKey = group.getKey();
        }
        view.id = viewID != null ? viewID : view.createIdFromPhrase();
        view.locale = null;
        view.userGroups = Collections.unmodifiableList(userGroupIDs.stream().map(GUID::toString).collect(Collectors.toList()));
        view.displayName = name;
        view.description = description;
        return view;
    }

    @Nonnull
    private String createIdFromPhrase() {
        Object id = this.phrase;
        if (this.parentId != null) {
            id = this.parentId + "_" + this.phrase;
        }
        id = ((String)id).replace("'", "").replace("\"", "").replace(" ", ".").replace(":", ".");
        id = ((String)id).replace("<=", "le");
        id = ((String)id).replace("<", "lt");
        id = ((String)id).replace(">=", "ge");
        id = ((String)id).replace(">", "gt");
        if (StringFunctions.isEmpty((String)this.phrase) && this.subViewGroupingKey != null) {
            return this.subViewGroupingKey;
        }
        return id;
    }

    @Override
    @Nonnull
    public String getID() {
        return this.id;
    }

    @Nullable
    public String getParentID() {
        return this.parentId;
    }

    @Nonnull
    private String getGlobalViewDefinition() {
        return this.parentId == null ? this.phrase : this.parentId + "|" + this.phrase;
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        if (StringFunctions.isEmpty((String)this.displayName)) {
            if (!StringFunctions.isEmpty((String)this.phrase)) {
                String globalViewDefinition;
                switch (globalViewDefinition = this.getGlobalViewDefinition()) {
                    case "lastchanged:7d": 
                    case "terminvereinbarungdate:>1d": 
                    case "statusid:\"150\"": 
                    case "opentickets|lastchanged:<1m": 
                    case "opentickets|inquirydate:<1m": 
                    case "opentickets|tickettags:\"0\"": 
                    case "opentickets|tickettags:\"2\"": 
                    case "opentickets|tickettags:\"3\"": 
                    case "opentickets|sumtime:>300": {
                        return Tickets.MSG.getMsg("view." + this.createIdFromPhrase(), new Object[0]);
                    }
                }
                if (globalViewDefinition.startsWith(GLOBAL_CLOSED_BASE) && globalViewDefinition.endsWith("d")) {
                    try {
                        int days = Integer.parseInt(globalViewDefinition.substring(GLOBAL_CLOSED_BASE.length(), globalViewDefinition.length() - 1));
                        return Tickets.MSG.getMsg("view.closedtickets", new Object[]{days});
                    }
                    catch (NumberFormatException days) {
                        // empty catch block
                    }
                }
                if (this.locale == null) {
                    try {
                        IndexSearchEngine<Integer> searchEngine = TicketManager.getReaderForSystem().getSearchEngine();
                        AndSearchExpression searchExpression = new TextSearchCommandBuilder(searchEngine, this.phrase).buildWithGenericLocale().getSearchExpression();
                        StringBuilder phraseBuilder = new StringBuilder();
                        searchExpression.toPhrase(phraseBuilder, searchEngine, false);
                        return phraseBuilder.toString();
                    }
                    catch (Throwable th) {
                        LogManager.getApplicationLogger().debug((Object)th);
                    }
                }
                return this.phrase;
            }
            if (this.subViewGroupingKey != null) {
                try {
                    SubViewGroupingDefinition subViewGrouping = (SubViewGroupingDefinition)DynamicExtensionManager.getInstance().getSingleInstanceByName(SubViewGroupingDefinition.class, this.subViewGroupingKey, false);
                    return subViewGrouping.getDisplayName();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return this.id;
        }
        return this.displayName;
    }

    @Nullable
    public String getRawDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public String getDescription() {
        if (StringFunctions.isEmpty((String)this.description)) {
            if (!StringFunctions.isEmpty((String)this.phrase)) {
                String globalViewDefinition;
                switch (globalViewDefinition = this.getGlobalViewDefinition()) {
                    case "lastchanged:7d": 
                    case "terminvereinbarungdate:>1d": 
                    case "statusid:\"150\"": 
                    case "opentickets|lastchanged:<1m": 
                    case "opentickets|inquirydate:<1m": 
                    case "opentickets|tickettags:\"0\"": 
                    case "opentickets|tickettags:\"2\"": 
                    case "opentickets|tickettags:\"3\"": 
                    case "opentickets|sumtime:>300": {
                        return Tickets.MSG.getMsg("view.description." + this.createIdFromPhrase(), new Object[0]);
                    }
                }
                if (globalViewDefinition.startsWith(GLOBAL_CLOSED_BASE) && globalViewDefinition.endsWith("d")) {
                    try {
                        int days = Integer.parseInt(globalViewDefinition.substring(GLOBAL_CLOSED_BASE.length(), globalViewDefinition.length() - 1));
                        return Tickets.MSG.getMsg("view.description.closedtickets", new Object[]{days});
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (this.subViewGroupingKey != null) {
                try {
                    SubViewGroupingDefinition subViewGrouping = (SubViewGroupingDefinition)DynamicExtensionManager.getInstance().getSingleInstanceByName(SubViewGroupingDefinition.class, this.subViewGroupingKey, false);
                    String subViewDescription = subViewGrouping.getDescription();
                    if (!StringFunctions.isEmpty((String)subViewDescription)) {
                        return subViewDescription;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return this.description;
        }
        return this.description;
    }

    @Nullable
    public String getRawDescription() {
        return this.description;
    }

    @Override
    public String getCategoryKey() {
        if (this.subViewGroupingKey != null) {
            return null;
        }
        return this.userGroups == null ? "myviews" : "globalviews";
    }

    @Override
    public String getSubViewGroupingKey() {
        return this.subViewGroupingKey;
    }

    public boolean isTokenizeGroupingValues() {
        return this.tokenizeGroupingValues;
    }

    public boolean isHideSubnodeTickets() {
        return this.hideSubnodeTickets;
    }

    public String getSearchPhrase() {
        if (this.locale == null) {
            try {
                IndexSearchEngine<Integer> searchEngine = TicketManager.getReaderForSystem().getSearchEngine();
                AndSearchExpression searchExpression = new TextSearchCommandBuilder(searchEngine, this.phrase).buildWithGenericLocale().getSearchExpression();
                StringBuilder phraseBuilder = new StringBuilder();
                searchExpression.toPhrase(phraseBuilder, searchEngine, false);
                return phraseBuilder.toString();
            }
            catch (Throwable th) {
                LogManager.getApplicationLogger().debug((Object)th);
            }
        }
        return this.phrase;
    }

    @Nonnull
    public SearchCommand createSearchCommand() {
        IndexSearchEngine<Integer> searchEngine = TicketManager.getReaderForSystem().getSearchEngine();
        HashSet<SearchTag> tags = new HashSet<SearchTag>(searchEngine.getTags());
        ArrayList<TokenMatcher> tokenMatcher = searchEngine.getTokenMatcher();
        if (!HDUsersAndGroups.isSupporter()) {
            tokenMatcher = null;
        }
        if (tokenMatcher != null) {
            tokenMatcher = new ArrayList<TokenMatcher>(tokenMatcher);
            tokenMatcher.removeIf(m -> !m.isTextSearchEnabled());
        }
        tags.removeIf(tag -> !tag.isTextSearchEnabled());
        TextSearchCommandBuilder builder = new TextSearchCommandBuilder(tags, tokenMatcher, this.phrase);
        SearchCommand command = this.locale == null ? builder.buildWithGenericLocale() : builder.build(LocaleUtils.valueOf((String)this.locale));
        command.getSearchExpression().add((SearchExpression)new SearchCondition("bundleslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagBundleSlave.FALSE));
        return command;
    }

    public List<String> getUserGroups() {
        return this.userGroups;
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        if (this.icondata == null) {
            if (!StringFunctions.isEmpty((String)this.phrase)) {
                String globalViewDefinition;
                switch (globalViewDefinition = this.getGlobalViewDefinition()) {
                    case "statusid:\"150\"": {
                        return CustomTicketViewDefinition.class.getResource("/com/inet/helpdesk/images/ticketview/remindertickets.png");
                    }
                    case "statusid:>=\"300\" closeddate:14d": {
                        return CustomTicketViewDefinition.class.getResource("/com/inet/helpdesk/images/Status-erledigt.gif");
                    }
                }
            }
            return TicketViewDefinition.super.getIconURL(iconKey, size);
        }
        String url = "data:image/png;base64," + Base64.encodeBytes((byte[])this.icondata);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            HDLogger.error(e);
            return null;
        }
    }

    public void resetViewIcon() {
        this.icondata = null;
    }

    public static void addCondition_forEndUserFromTicketNumber(@Nonnull GUID userAccountId, @Nonnull AndSearchExpression and) {
        UserAccount userAccount;
        Integer minValue = (Integer)ENDUSDER_FROM_TICKET_NUM.get();
        if (minValue != null && minValue > 1 && !HDUsersAndGroups.isSupporter(userAccount = UserManager.getInstance().getUserAccount(userAccountId))) {
            and.add((SearchExpression)new SearchCondition("ticketid", SearchCondition.SearchTermOperator.GE, (Object)minValue));
        }
    }

    public GUID getOriginalCreator() {
        return this.originalCreator;
    }
}

